% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{load_shark4r_stats}
\alias{load_shark4r_stats}
\title{Load SHARK4R statistics from GitHub}
\usage{
load_shark4r_stats(file_name = "sea_basin.rds", verbose = TRUE)
}
\arguments{
\item{file_name}{Character string specifying the name of the \code{.rds} file to download.
Defaults to \code{"sea_basin.rds"}.}

\item{verbose}{Logical; if \code{TRUE} (default), prints progress messages during download and loading.}
}
\value{
An R object (typically a \code{tibble} or \code{data.frame}) read from the specified \code{.rds} file.
}
\description{
This function downloads and loads precomputed SHARK4R statistical data
(e.g., threshold or summary statistics) directly from the
\href{https://github.com/nodc-sweden/SHARK4R-statistics}{SHARK4R-statistics} GitHub repository.
The data are stored as \code{.rds} files and read into R as objects.
}
\details{
The function retrieves the file from the GitHub repository’s \verb{data/} folder.
It temporarily downloads the file to the local system and then reads it into R using \code{readRDS()}.

If the download fails (e.g., due to a network issue or invalid filename), the function
throws an error with a descriptive message.
}
\examples{
\donttest{
# Load the default SHARK4R statistics file
stats <- load_shark4r_stats(verbose = FALSE)
print(stats)

# Load a specific file
thresholds <- load_shark4r_stats("scientific_name.rds", verbose = FALSE)
print(thresholds)
}

}
\seealso{
\code{\link{check_outliers}} for detecting threshold exceedances using the loaded statistics,
\code{\link{get_shark_statistics}} for generating and caching statistical summaries used in SHARK4R.
\code{\link{scatterplot}} for generating interactive plots with threshold values.
}
