% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEMhelp.R
\name{trainingReport}
\alias{trainingReport}
\title{Training history evaluation of a DNN model}
\usage{
trainingReport(object, size = NULL, r = 2, c = 2, ...)
}
\arguments{
\item{object}{A model fitting object from \code{SEMdnn()} function.}

\item{size}{number of the multiple plots (default, \code{size = NULL}:
all training MLP for each bootstrap sample are visualized).}

\item{r}{number of rows of the plot layout (default, \code{r = 2}).}

\item{c}{number of columns of the plot layout (default, \code{c = 2}).}

\item{...}{Currently ignored.}
}
\value{
Invisibly returns a data.frame of the training loss history.
}
\description{
Display a (r,c) panel history plot from \code{SEMdnn()} output,
with x = number of epochs, y = training loss for each MLP model and bootstrap
sample, if \code{nboot} > 0.
}
\details{
The training history plot can provide an indication about the training
of the model, such as: (i) its speed of convergence over epochs (slope), (ii)
whether the model may have already converged (plateau of the line), (iii) whether
the mode may be over-learning the training data (inflection for validation line),
and more.
}
\examples{

\donttest{
if (torch::torch_is_installed()){

# Load Sachs data (pkc)
ig<- sachs$graph
data<- sachs$pkc
data<- transformData(data)$data
group<- sachs$group

#...with train-test (0.5-0.5) samples
set.seed(123)
train<- sample(1:nrow(data), 0.5*nrow(data))

dnn <- SEMdnn(ig, data[train, ], algo = "layerwise",
              hidden = 10, link = "relu", loss = "mse",
              validation = 0.2, nboot = 0, epochs = 32)

tr <- trainingReport(dnn); tr
}
}

}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
