% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEMdnn.R
\name{predict.DNN}
\alias{predict.DNN}
\title{SEM-based out-of-sample prediction using DNN}
\usage{
\method{predict}{DNN}(object, newdata, newoutcome = NULL, verbose = FALSE, ...)
}
\arguments{
\item{object}{A model fitting object from \code{SEMdnn()} function.}

\item{newdata}{A matrix containing new data with rows corresponding to
subjects, and columns to variables. If newdata = NULL, the train data are used.}

\item{newoutcome}{A new character vector (as.factor) of labels for a categorical
output (target) (default = NULL).}

\item{verbose}{Print predicted out-of-sample MSE values (default = FALSE).}

\item{...}{Currently ignored.}
}
\value{
A list of three objects:
\enumerate{
\item "PE", vector of the amse = average MSE over all (sink and mediators)
graph nodes; r2 = 1 - amse; and srmr= Standardized Root Means Square Residual
between the out-of-bag correlation matrix and the model correlation matrix.
\item "mse", vector of the Mean Squared Error (MSE) for each out-of-bag
prediction of the sink and mediators graph nodes.
\item "Yhat", the matrix of continuous predicted values of graph nodes  
(excluding source nodes) based on out-of-bag samples. 
}
}
\description{
Predict method for DNN objects.
}
\examples{

\donttest{
if (torch::torch_is_installed()){

# Load Amyotrophic Lateral Sclerosis (ALS)
ig<- alsData$graph
data<- alsData$exprs
data<- transformData(data)$data
group<- alsData$group 

#...with train-test (0.5-0.5) samples
set.seed(123)
train<- sample(1:nrow(data), 0.5*nrow(data))
#ncores<- parallel::detectCores(logical = FALSE)

start<- Sys.time()
dnn0 <- SEMdnn(ig, data[train, ], algo ="layerwise",
			hidden = c(10,10,10), link = "selu", bias = TRUE,
			nboot = 0, epochs = 32, verbose = TRUE)
end<- Sys.time()
print(end-start)
pred.dnn <- predict(dnn0, data[-train, ], verbose=TRUE)

# SEMrun vs. SEMdnn MSE comparison
sem0 <- SEMrun(ig, data[train, ], algo="ricf", n_rep=0)
pred.sem <- predict(sem0, data[-train,], verbose=TRUE)

#...with a categorical (as.factor) outcome
outcome <- factor(ifelse(group == 0, "control", "case")); table(outcome) 

start<- Sys.time()
dnn1 <- SEMdnn(ig, data[train, ], outcome[train], algo ="layerwise",
			hidden = c(10,10,10), link = "selu", bias = TRUE,
			nboot = 0, epochs = 32, verbose = TRUE)
end<- Sys.time()
print(end-start)

pred <- predict(dnn1, data[-train, ], outcome[-train], verbose=TRUE)
yhat <- pred$Yhat[ ,levels(outcome)]; head(yhat)
yobs <- outcome[-train]; head(yobs)
classificationReport(yobs, yhat, verbose=TRUE)$stats
}
}

}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
