% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoTemp.R
\name{geoTemp}
\alias{geoTemp}
\title{Generate Geometric Temperature Ladder for Parallel Tempering}
\usage{
geoTemp(N, T1 = 1, TN = 20)
}
\arguments{
\item{N}{Integer > 1, number of chains/temperatures.}

\item{T1}{Numeric > 0, coldest temperature (usually 1).}

\item{TN}{Numeric > T1, hottest temperature.}
}
\value{
Numeric vector of length N containing the geometrically spaced
        temperatures T_1, T_2, ..., T_N.
}
\description{
Produces a geometric progression of inverse-temperatures (or temperatures)
commonly used in parallel-tempered MCMC algorithms.
}
\examples{
geoTemp(8, T1 = 1, TN = 20)

}
