% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{grubbs}
\alias{grubbs}
\alias{crit.grubbs}
\title{Grubbs outlier test}
\usage{
grubbs(x, varEstim = var)

crit.grubbs(n, alpha = 0.05)
}
\arguments{
\item{x}{numeric vector.}

\item{varEstim}{Variance estimation or estimation function. Either a numeric value or a function taking one argument.}

\item{n}{sample size; positive numeric value.}

\item{alpha}{significance level; between 0 and 1.}
}
\value{
numeric value.
}
\description{
Computes the test statistic and the critical value of the outlier test according to Grubbs.
}
\examples{
x <- rnorm(100)
grubbs(x) > crit.grubbs(100, 0.05)

# add outlier
x[1] <- x[1] + 100
grubbs(x) > crit.grubbs(100, 0.05)


}
