% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{occ_flagged}
\alias{occ_flagged}
\title{Flagged occurrence records of \emph{Araucaria angustifolia}}
\format{
A data frame where each row corresponds to a georeferenced occurrence
of \emph{A. angustifolia}.
}
\usage{
occ_flagged
}
\description{
A dataset containing the occurrence records of \emph{Araucaria angustifolia}
after applying several of the package’s flagging and data-quality
assessment functions.
}
\examples{
# First rows
head(occ_flagged)

# Count flagged vs. unflagged records
table(occ_flagged$correct_country)


}
\seealso{
\code{occurrences},
\code{standardize_countries()}, \code{standardize_states()},
\code{flag_florabr()}, \code{flag_wcvp()}, \code{flag_iucn()},
\code{flag_cultivated()}, \code{flag_inaturalist()},
\code{flag_duplicates()}, \code{mapview_here()}
}
\keyword{datasets}
