% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_density_plot.R
\name{create_density_plot}
\alias{create_density_plot}
\title{create_density_plot}
\usage{
create_density_plot(
  df = NULL,
  aes_x = NULL,
  aes_color = NULL,
  aes_fill = NULL,
  bw = "nrd0",
  adjust = 1,
  kernel = "gaussian",
  n = 512,
  position = "identity",
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  center_titles = FALSE,
  x_title = NULL,
  y_title = NULL,
  hide_x_tics = FALSE,
  hide_y_tics = FALSE,
  rot_x_tic_angle = 0,
  rot_y_tic_label = FALSE,
  density_linewdth = 1,
  density_color = "black",
  density_fill = "gray",
  density_alpha = 0.4,
  x_limits = NULL,
  x_major_breaks = waiver(),
  x_minor_breaks = waiver(),
  x_labels = waiver(),
  y_limits = NULL,
  y_major_breaks = waiver(),
  y_minor_breaks = waiver(),
  y_labels = waiver(),
  axis_text_size = 11,
  show_major_grids = TRUE,
  show_minor_grids = TRUE,
  plot_obs = FALSE,
  plot_obs_len = 0.02,
  plot_obs_color = "black",
  bold_x = NULL,
  bold_x_color = "black",
  bold_x_linetype = "dashed",
  panel_color = "white",
  panel_border_color = "black",
  show_legend = TRUE,
  legend_pos = "right",
  legend_key_width = 0.7,
  legend_key_height = 0.7,
  legend_key_backgrd = "white",
  silent_NA_warning = FALSE,
  cum_prob = NULL,
  area_colors = c("gray", "green", "gray"),
  area_quantile_line_color = "red",
  png_file_path = NULL,
  png_width_height = c(480, 480)
)
}
\arguments{
\item{df}{A required data frame that contains a numeric column from which to estimate the KDE along with possible variables
for setting 'aes_color' and 'aes_fill' (see below).}

\item{aes_x}{A required string that sets the variable of 'df' from which to estimate the KDE.}

\item{aes_color}{Sets the variable name from 'df' for the aesthetic mapping for color.}

\item{aes_fill}{Sets the variable name from 'df' for the aesthetic mapping for fill.}

\item{bw}{A string or numeric that sets the smoothing bandwidth to be used with the KDE function.}

\item{adjust}{A numeric that adjusts 'bw' since the actual bandwidth is computed as \code{adjust*bw}.}

\item{kernel}{A string that set the type of Kernel Density Estimation (KDE). Acceptable values are "gaussian",
"rectangular", "triangular", "epanechnikov", "biweight", "cosine" or "optcosine".}

\item{n}{The number of equally spaced points at which the density is to be estimated. This should be a power of two.}

\item{position}{A string that sets the position.  Acceptable values are "identity" which overlays or
"stack" which stacks.}

\item{title}{A string that sets the overall title.}

\item{subtitle}{A string that sets the overall subtitle.}

\item{caption}{A string that sets the plot caption}

\item{center_titles}{A logical which if \code{TRUE} centers both the 'title' and 'subtitle'.}

\item{x_title}{A string that sets the x axis title. If \code{NULL} (the default)  then the x axis title does not appear.}

\item{y_title}{A string that sets the y axis title. If \code{NULL} (the default)  then the y axis title does not appear.}

\item{hide_x_tics}{A logical that controls the appearance of the x axis tics.}

\item{hide_y_tics}{A logical that controls the appearance of the y axis tics.}

\item{rot_x_tic_angle}{A numeric that sets the angle of rotation for the x tic labels. When x tic labels are long,
a value of 40 for this argument usually works well.}

\item{rot_y_tic_label}{A logical which if TRUE rotates the y tic labels 90 degrees for enhanced readability.}

\item{density_linewdth}{A numeric that sets the width attribute for the density line .}

\item{density_color}{A string that sets the color attribute for the density line .}

\item{density_fill}{A string that sets the fill color attribute for the area under the density line.}

\item{density_alpha}{A numeric that sets the alpha attribute value for 'density_fill'.}

\item{x_limits}{A numeric 2 element vector or function that sets the minimum and maximum for the x axis. Use NA to
refer to the existing minimum and maximum.}

\item{x_major_breaks}{A numeric vector or function that sets the major tic locations along the x axis.}

\item{x_minor_breaks}{A numeric vector or function that sets the minor tic locations along the x axis.}

\item{x_labels}{A character vector or function giving x axis tic labels.  Must be the same length as 'x_breaks'.}

\item{y_limits}{A numeric 2 element vector or function that sets the minimum and maximum for the y axis.  Use NA to
refer to the existing minimum and maximum.}

\item{y_major_breaks}{A numeric vector or function that sets the major tic locations along the y axis.}

\item{y_minor_breaks}{A numeric vector or function that sets the minor tic locations along the y axis.}

\item{y_labels}{A character vector or function giving y axis tic labels.  Must be the same length as 'y_breaks'.}

\item{axis_text_size}{A numeric that sets the font size along the axis'. Default is 11.}

\item{show_major_grids}{A logical that controls the appearance of major grids.}

\item{show_minor_grids}{A logical that controls the appearance of minor grids.}

\item{plot_obs}{A logical which if \code{TRUE} plots a line for each observation along the axis margin.}

\item{plot_obs_len}{A numeric that sets the length of the 'plot_obs' lines.}

\item{plot_obs_color}{A string that sets the color of the 'plot_obs' lines.}

\item{bold_x}{A numeric that sets the x-intercept for plotting a bold vertical line.}

\item{bold_x_color}{A string that sets the color of 'bold_x'.}

\item{bold_x_linetype}{A string that set the linetype of 'bold_x'.}

\item{panel_color}{A string in hexidecimal or color name that sets the plot panel's color.
The default is "white".}

\item{panel_border_color}{A string in hexidecimal or color name that sets the plot panel's border color.
The default is "black".}

\item{show_legend}{A logical that controls the appearance of the legend.}

\item{legend_pos}{A string that sets the legend position. Acceptable values are
"top", "bottom", "left", "right".}

\item{legend_key_width}{A numeric that sets the legend width in cm.}

\item{legend_key_height}{A numeric that sets the legend height in cm.}

\item{legend_key_backgrd}{A string that sets the legend's background color.}

\item{silent_NA_warning}{A logical that controls the appearance of a console warning when Na's
are removed.}

\item{cum_prob}{A one or two element numeric vector for defining cumulative probabilities which divide the density plot area. The
values are probabilities with values within 0.0 to 1.0.  If for example with a cumulative probability 'cum_prob' of .95, then the density is divided
into two probability areas of 95% and 5% with the dividing quantile value labeled. Similarly if two cumulative probabilities are submitted,
then three areas are defined.}

\item{area_colors}{A string vector that sets the color of each area defined by 'cum_prob'.}

\item{area_quantile_line_color}{A string that sets the vertical line color at quantile locations that divide the areas defined
by \code{cum_prob}.}

\item{png_file_path}{A character string with the directory and file name to produce
a png image of the plot.}

\item{png_width_height}{A numeric vector that sets the width and height of the png image in pixels. The
default is c(480,480).  There are 37.8 pixels in a centimeter.}
}
\value{
A ggplot class object.
}
\description{
Function creates a ggplot2 based density plot with options for scaling, shading probability areas,
 and plotting observation locations. The function's density arguments mirror most of the arguments available
 from \code{\link{density}} for the Kernel Density Estimation (KDE). See the \code{\link{density}} help page
 for more information.
}
\examples{
library(ggplot2)
library(rlang)
library(data.table)
library(RplotterPkg)

RplotterPkg::create_density_plot(
  df = datasets::airquality,
  aes_x = "Ozone",
  rot_y_tic_label = TRUE,
  x_limits = c(-40,200),
  x_major_breaks = seq(-40,200,20),
  title = "Ozone Air Quality",
  x_title = "Ozone",
  y_title = "Density",
  plot_obs = TRUE,
  density_fill = "green",
  density_alpha = 0.5
)

}
