% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rpdb-package.R
\name{Rpdb-package}
\alias{Rpdb-package}
\title{Read, Write, Visualize and Manipulate PDB Files}
\description{
Provides tools to read, write, visualize PDB files, and perform structural manipulations.
}
\details{
This package enables users, e.g. computational chemists,
to manipulate molecular structures stored in PDB files.
It enables users ro read, write and visualize PDB files.
Various basic structural manipulations are also supported.
Conversion of Cartesian coordinates into fractional coordinates.
Spliting a molecular structure into fragments.
Computation of centers-of-geometry and centers-of-mass.
Wrapping molecular structure using periodical boundary conditions.
Translation, rotation and reflection of atomic coordinates.
Calculate atomic bond lengths, angles and dihedrals.
}
\examples{
## Read a PDB file included in the package
x <- read.pdb(system.file("examples/PCBM_ODCB.pdb", package="Rpdb"))

## Visualize the PDB file
visualize(x, mode = NULL)

## From Cartesian to fractional coordinates and vice versa
x <- xyz2abc(x)
basis(x)
natom(x, x$atoms$resid)
range(x)
centres(x)
x <- abc2xyz(x)
basis(x)
natom(x, x$atoms$resid)
range(x)
centres(x)

## Split and unsplit
F <- x$atoms$resid
x <-   split(x, F)
x <- unsplit(x, F)

## Subset and merge
x.PCB.only <- subset(x, resname == "PCB")
x.DCB.only <- subset(x, resname == "DCB")
x <- merge(x.PCB.only, x.DCB.only)

## Duplicate and wrap
x <- replicate(x, a.ind = -1:1, b.ind = -1:1, c.ind = -1:1)
x <- wrap(x)

## Write the 'pdb' object 'x' to a temporary file.
write.pdb(x, file = tempfile())

}
\references{
More information on the PDB format can be found here:\cr
http://www.wwpdb.org/documentation/format33/v3.3.html
}
\author{
Julien Idé \email{julien.ide.fr@gmail.com}\cr
}
\keyword{package}
