% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.RoBMA}
\alias{plot.RoBMA}
\title{Plots a fitted RoBMA object}
\usage{
\method{plot}{RoBMA}(
  x,
  parameter = "mu",
  conditional = FALSE,
  plot_type = "base",
  prior = FALSE,
  output_scale = NULL,
  rescale_x = FALSE,
  show_data = TRUE,
  dots_prior = NULL,
  ...
)
}
\arguments{
\item{x}{a fitted RoBMA object}

\item{parameter}{a parameter to be plotted. Defaults to
\code{"mu"} (for the effect size). The additional options
are \code{"tau"} (for the heterogeneity),
\code{"weightfunction"} (for the estimated weightfunction),
or \code{"PET-PEESE"} (for the PET-PEESE regression).}

\item{conditional}{whether conditional estimates should be
plotted. Defaults to \code{FALSE} which plots the model-averaged
estimates. Note that both \code{"weightfunction"} and
\code{"PET-PEESE"} are always ignoring the other type of
publication bias adjustment.}

\item{plot_type}{whether to use a base plot \code{"base"}
or ggplot2 \code{"ggplot"} for plotting. Defaults to
\code{"base"}.}

\item{prior}{whether prior distribution should be added to
figure. Defaults to \code{FALSE}.}

\item{output_scale}{transform the effect sizes and the meta-analytic
effect size estimate to a different scale. Defaults to \code{NULL}
which returns the same scale as the model was estimated on.}

\item{rescale_x}{whether the x-axis of the \code{"weightfunction"}
should be re-scaled to make the x-ticks equally spaced.
Defaults to \code{FALSE}.}

\item{show_data}{whether the study estimates and standard
errors should be show in the \code{"PET-PEESE"} plot.
Defaults to \code{TRUE}.}

\item{dots_prior}{list of additional graphical arguments
to be passed to the plotting function of the prior
distribution. Supported arguments are \code{lwd},
\code{lty}, \code{col}, and \code{col.fill}, to adjust
the line thickness, line type, line color, and fill color
of the prior distribution respectively.}

\item{...}{list of additional graphical arguments
to be passed to the plotting function. Supported arguments
are \code{lwd}, \code{lty}, \code{col}, \code{col.fill},
\code{xlab}, \code{ylab}, \code{main}, \code{xlim}, \code{ylim}
to adjust the line thickness, line type, line color, fill color,
x-label, y-label, title, x-axis range, and y-axis range
respectively.}
}
\value{
\code{plot.RoBMA} returns either \code{NULL} if \code{plot_type = "base"}
or an object object of class 'ggplot2' if \code{plot_type = "ggplot2"}.
}
\description{
\code{plot.RoBMA} allows to visualize
different \code{"RoBMA"} object parameters in various
ways. See \code{type} for the different model types.
}
\examples{
\dontrun{
# using the example data from Anderson et al. 2010 and fitting the default model
# (note that the model can take a while to fit)
fit <- RoBMA(r = Anderson2010$r, n = Anderson2010$n, study_names = Anderson2010$labels)

### ggplot2 version of all of the plots can be obtained by adding 'model_type = "ggplot"
# the 'plot' function allows to visualize the results of a fitted RoBMA object, for example;
# the model-averaged effect size estimate
plot(fit, parameter = "mu")

# and show both the prior and posterior distribution
plot(fit, parameter = "mu", prior = TRUE)

# conditional plots can by obtained by specifying
plot(fit, parameter = "mu", conditional = TRUE)

# plotting function also allows to visualize the weight function
plot(fit, parameter = "weightfunction")

# re-scale the x-axis
plot(fit, parameter = "weightfunction", rescale_x = TRUE)

# or visualize the PET-PEESE regression line
plot(fit, parameter = "PET-PEESE")
}


}
\seealso{
\code{\link[=RoBMA]{RoBMA()}}
}
