% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots_sim_est.R
\name{plot_tsest}
\alias{plot_tsest}
\title{Plot the estimated Hurst functions and local fractal dimension estimates
for a user provided time series}
\usage{
plot_tsest(
  X,
  H_Est = TRUE,
  H_Smooth_Est = TRUE,
  LFD_Est = TRUE,
  LFD_Smooth_Est = TRUE,
  N = 100,
  Q = 2,
  L = 2
)
}
\arguments{
\item{X}{Data frame where the first column is a numeric time sequence \eqn{t}
and the second one is the values of the time series \eqn{X(t)}.
To get reliable results for time series, it is recommended to use at least 500 time points.}

\item{H_Est}{Logical: If \code{TRUE}, the Hurst function estimated by using \code{\link{Hurst}} is plotted.}

\item{H_Smooth_Est}{Logical: If \code{TRUE}, the smoothed estimated Hurst function is plotted.
The estimated Hurst function is smoothed using the loess method.}

\item{LFD_Est}{Logical: If \code{TRUE}, the local fractal dimension estimates are plotted.}

\item{LFD_Smooth_Est}{Logical: If \code{TRUE}, the smoothed estimates of local fractal dimension is plotted.
Smoothed using the loess method.}

\item{N}{Argument used for the estimation of Hurst functions and LFD. Number of sub-intervals on which the estimation is performed on. Default is set to 100 sub-intervals.}

\item{Q}{Argument used for the estimation of Hurst functions and LFD. Fixed integer greater than or equal to 2. Default is set to 2.}

\item{L}{Argument used for the estimation of Hurst functions and LFD. Fixed integer greater than or equal to 2. Default is set to 2.}
}
\value{
A ggplot object which is used to plot the time series with raw and smoothed estimates of Hurst function
and local fractal dimension.
}
\description{
Creates a plot of the user provided time series with the
Hurst function estimated using \code{\link{Hurst}}, the smoothed estimated
Hurst function and local fractal dimension estimated using \code{\link{LFD}}
and smoothed estimates of local fractal dimension.
}
\details{
Compared to \code{\link{plot.H_LFD}} the function's first argument is a time series,
not \code{H_LFD} object.
}
\examples{
TS <- data.frame("t" = seq(0, 1, length = 1000), "X(t)" = rnorm(1000))
#Plot of time series, estimated and smoothed Hurst and LFD estimates
plot_tsest(TS)

}
\seealso{
\code{\link{Hurst}}, \code{\link{LFD}}, \code{\link{plot.H_LFD}}
}
