% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NEC.R
\name{NEC}
\alias{NEC}
\title{Non Euclidean Algorithm to Cluster}
\usage{
NEC(data, distance, k, centers_function, init_centers, seed = NULL, ITER, COTA)
}
\arguments{
\item{data}{Matrix with \code{dim(data)[1]} points of \code{dim(data)[2]} dimensions.}

\item{distance}{Function. This function designs how the distance is going to be calculated. It must have as input two vectors and as output the distance of these vectors.}

\item{k}{Number. Number of groups into which we are going to group the different points.}

\item{centers_function}{Function. This function designs how the centers of the groups will be calculated. It must have as input \code{data} and \code{grouping} and as output a matrix that has the centers. This matrix will have as many rows as centers. With \code{grouping} we mean a list. The list component i has a vector with the numbers of the row of the matrix \code{data} where the points belonging to group i are.}

\item{init_centers}{Function. This function designs how we are going to calculate the initial centers. The input must be the \code{data}, \code{distance} and \code{k} and the output must be a matrix where each row has the center of one group.}

\item{seed}{Number. Number to fix a seed and be able to reproduce your results.}

\item{ITER}{Number. Maximum number of iterations.}

\item{COTA}{Number. The process is stopped when the distance between a center and the previous one is smaller than COTA.}
}
\value{
Returns a list with:

\itemize{
\item FHW_output; is a list with
     \itemize{
  \item centers: the information of the centers updated. Matrix with \code{dim(centers)[1]} centers of \code{dim(centers)[2]} dimensions.
  \item grouping: the information of the groups updated. List. Each component of the list contains a vector with the points that belong to that group. More specifically, the list component i has a vector with the numbers of the row of the matrix \code{data} where the points belonging to group i are.
   }
 \item Stop_Criteria: returns the distance between one center and the previous one for all the iterations
 \item Chanche_yes_no: matrix, in the position \code{[i,j]} returns "yes" if the point i have changed its group in the iteration j and return "no" if the point have not changed.
 \item all_output: is a list with the information of the center and the groups of each iteration of the process

   }
}
\description{
We give initial centers, calculate the distance between each point and each center and assign each point to the center with minimum distance. Calculate the center of the group and repeat the process. The process is stopped when the distance between a center and the previous one is small than COTA or the maximum number of iterations is reached.
}
\examples{
set.seed(451)
data=rbind(matrix(runif(20,1,5), nrow = 2, ncol = 10),
          matrix(runif(20,20,30), nrow = 2, ncol = 10),
          matrix(runif(20,50,70), nrow = 2, ncol = 10))
k=3
seed=5


o2=NEC(data,
      RelativeDistance,
      k,
      centers_function_RelativeDistance,
      init_centers_random,
      seed=seed,
      10,
      0.01)


}
