% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_bayesian.R
\name{regime_detector}
\alias{regime_detector}
\title{Create Online Regime Detector}
\usage{
regime_detector(
  method = c("bocpd", "cusum", "shiryaev"),
  prior = NULL,
  hazard = NULL,
  threshold = NULL,
  ...
)
}
\arguments{
\item{method}{Detection method: "bocpd", "cusum", or "shiryaev"}

\item{prior}{Prior specification for Bayesian methods}

\item{hazard}{Hazard prior for changepoint occurrence}

\item{threshold}{Detection threshold (probability or statistic value)}

\item{...}{Additional method-specific parameters}
}
\value{
An object of class "regime_detector"
}
\description{
Creates a detector object for online (sequential) changepoint detection.
The detector maintains state and can be updated incrementally as new
observations arrive.
}
\examples{
detector <- regime_detector(method = "bocpd",
                            prior = normal_gamma(),
                            threshold = 0.5)

\donttest{
for (x in rnorm(100)) {
  detector <- update(detector, x)
  if (detector$last_result$alarm) {
    message("Change detected at observation ", detector$last_result$t)
    detector <- reset(detector)
  }
}
}

}
