% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{normal_wishart}
\alias{normal_wishart}
\title{Normal-Wishart Prior for Multivariate Data}
\usage{
normal_wishart(mu0, kappa0 = 1, nu0 = NULL, Psi0 = NULL)
}
\arguments{
\item{mu0}{Prior mean vector (d-dimensional)}

\item{kappa0}{Prior pseudo-observations for the mean}

\item{nu0}{Degrees of freedom for the Wishart (must be >= d)}

\item{Psi0}{Scale matrix for the Wishart (d x d positive definite)}
}
\value{
An object of class "regime_prior"
}
\description{
Creates a Normal-Wishart prior for multivariate normal data with unknown
mean vector and covariance matrix.
}
\examples{
prior <- normal_wishart(
  mu0 = c(0, 0),
  kappa0 = 1,
  nu0 = 3,
  Psi0 = diag(2)
)

}
