% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl.R
\name{cl_charset_name}
\alias{cl_charset_name}
\title{Get charset of a corpus.}
\usage{
cl_charset_name(corpus, registry = Sys.getenv("CORPUS_REGISTRY"))
}
\arguments{
\item{corpus}{Name of a CWB corpus (upper case).}

\item{registry}{Path to the registry directory, defaults to the value of the
environment variable CORPUS_REGISTRY}
}
\description{
The encoding of a corpus is declared in the registry file (corpus property
"charset"). Once a corpus is loaded, this information is available without
parsing the registry file again and again. The \code{cl_charset_name} offers
a quick access to this information.
}
\examples{
cl_charset_name(
  corpus = "REUTERS",
  registry = system.file(package = "RcppCWB", "extdata", "cwb", "registry")
)
}
