% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Node_Perturbation.R
\name{node.removal.thread}
\alias{node.removal.thread}
\title{Simulates Network Dynamics under Random Node Removal Perturbations.}
\usage{
node.removal.thread(
  system,
  M,
  x0,
  initial_params = list(),
  update_params = identity,
  reduction = identity,
  removal_order = NULL,
  ...
)
}
\arguments{
\item{system}{A function defining the system's dynamics: `system(time, x, params)` which returns a list of state deltas `dx`.}

\item{M}{The initial adjacency matrix of the network.}

\item{x0}{Initial conditions of the network's nodes (numeric vector).}

\item{initial_params}{Either a list of initial parameters, or a function of type `f(M) -> list` that takes the adjacency matrix of the network as input and returns the initial parameters of the system.}

\item{update_params}{A function of type `f(list) -> list` that receives the list of parameters after each perturbation, and returns a new list of parameters. Defaults to `identity`.}

\item{reduction}{A reduction function applied to the ODE solution. This can be `identity` (for all node states) or functions like `mean` or `median`. The function signature should be either `f(numeric) -> numeric` or `f(matrix) -> matrix`, depending on whether `only.final.state` is `TRUE` or `FALSE`.}

\item{removal_order}{The removal order of the nodes. Leave NULL for a random removal order.}

\item{...}{Additional arguments passed to the ODE solver (e.g., `method`, `atol`).}
}
\value{
Depending on `to.numeric`, returns either a list or a numeric matrix, representing the system's state across multiple perturbations.
If `to.numeric` is `FALSE`, the function returns a list `L`, where `L[[i]]`
represents the final state of the system after the `i`-th perturbation. If `TRUE`, the list is converted to a
numeric matrix before being returned.#'
}
\description{
This function simulates the behavior of a network undergoing multiple uniform removal of nodes.
Starting with an initial healthy network, it calculates the network's trajectory by solving the system of
ordinary differential equations (ODEs) after each perturbation. Nodes are removed randomly and uniformly, followed by
dimension reduction using the specified reduction function.
}
\examples{
   node_file <- system.file("extdata", "IL17.nodes.csv", package = "Rato")
   edge_file <- system.file("extdata", "IL17.edges.csv", package = "Rato")
   g <- Rato::graph.from.csv(node_file, edge_file, sep=",", header=TRUE)
 
   Rato::node.removal.thread( Rato::Michaelis.Menten
                             , g$M
                             , g$initial_values
                             , initial_params = list('f' = 1, 'h'=2, 'B'=0.1))

}
