% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta2.R
\name{beta2}
\alias{beta2}
\alias{dbeta}
\alias{dbeta2}
\alias{pbeta2}
\alias{qbeta2}
\alias{rbeta2}
\title{Reparameterised beta distribution}
\usage{
dbeta(x, shape1, shape2, log = FALSE, eps = 0)

dbeta2(x, mu, phi, log = FALSE, eps = 0)

pbeta2(q, mu, phi, lower.tail = TRUE, log.p = FALSE)

qbeta2(p, mu, phi, lower.tail = TRUE, log.p = FALSE)

rbeta2(n, mu, phi)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{shape1, shape2}{non-negative parameters}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{eps}{for internal use only, don't change.}

\item{mu}{mean parameter, must be in the interval from 0 to 1.}

\item{phi}{concentration parameter, must be positive.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are \eqn{P[X \le x]}, otherwise \eqn{P[X > x]}.}

\item{p}{vector of probabilities}

\item{n}{number of random values to return.}
}
\value{
\code{dbeta2} gives the density, \code{pbeta2} gives the distribution function, \code{qbeta2} gives the quantile function, and \code{rbeta2} generates random deviates.
}
\description{
Density, distribution function, quantile function, and random generation for
the beta distribution reparameterised in terms of mean and concentration.
}
\details{
This implementation allows for automatic differentiation with \code{RTMB}.

Currently, \code{dbeta} masks \code{RTMB::dbeta} because the latter has a numerically unstable gradient.
}
\examples{
set.seed(123)
x <- rbeta2(1, 0.5, 1)
d <- dbeta2(x, 0.5, 1)
p <- pbeta2(x, 0.5, 1)
q <- qbeta2(p, 0.5, 1)
}
