% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R, R/Result.R
\docType{class}
\name{AthenaConnection}
\alias{AthenaConnection}
\alias{AthenaConnection-class}
\alias{show,AthenaConnection-method}
\alias{dbDisconnect,AthenaConnection-method}
\alias{dbIsValid,AthenaConnection-method}
\alias{dbSendQuery,AthenaConnection,character-method}
\alias{dbSendStatement,AthenaConnection,character-method}
\alias{dbExecute,AthenaConnection,character-method}
\alias{dbDataType,AthenaConnection,ANY-method}
\alias{dbDataType,AthenaConnection,data.frame-method}
\alias{dbQuoteString,AthenaConnection,character-method}
\alias{dbQuoteString,AthenaConnection,POSIXct-method}
\alias{dbQuoteString,AthenaConnection,Date-method}
\alias{dbQuoteIdentifier,AthenaConnection,SQL-method}
\alias{dbGetTables}
\alias{dbGetTables,AthenaConnection-method}
\alias{dbListFields,AthenaConnection,character-method}
\alias{dbExistsTable,AthenaConnection,character-method}
\alias{dbExistsTable,AthenaConnection,Id-method}
\alias{dbRemoveTable,AthenaConnection,character-method}
\alias{dbRemoveTable,AthenaConnection,Id-method}
\alias{dbGetQuery,AthenaConnection,character-method}
\alias{dbGetInfo,AthenaConnection-method}
\alias{dbGetPartition}
\alias{dbGetPartition,AthenaConnection-method}
\alias{dbShow}
\alias{dbShow,AthenaConnection-method}
\alias{dbBegin,AthenaConnection-method}
\alias{dbCommit,AthenaConnection-method}
\alias{dbRollback,AthenaConnection-method}
\alias{AthenaResult-class}
\title{Athena Connection Methods}
\usage{
\S4method{show}{AthenaConnection}(object)

\S4method{dbDisconnect}{AthenaConnection}(conn, ...)

\S4method{dbIsValid}{AthenaConnection}(dbObj, ...)

\S4method{dbSendQuery}{AthenaConnection,character}(conn, statement, unload = athena_unload(), ...)

\S4method{dbSendStatement}{AthenaConnection,character}(conn, statement, unload = athena_unload(), ...)

\S4method{dbExecute}{AthenaConnection,character}(conn, statement, unload = athena_unload(), ...)

\S4method{dbDataType}{AthenaConnection,ANY}(dbObj, obj, ...)

\S4method{dbDataType}{AthenaConnection,data.frame}(dbObj, obj, ...)

\S4method{dbQuoteString}{AthenaConnection,character}(conn, x, ...)

\S4method{dbQuoteString}{AthenaConnection,POSIXct}(conn, x, ...)

\S4method{dbQuoteString}{AthenaConnection,Date}(conn, x, ...)

\S4method{dbQuoteIdentifier}{AthenaConnection,SQL}(conn, x, ...)

dbGetTables(conn, ...)

\S4method{dbGetTables}{AthenaConnection}(conn, catalog = NULL, schema = NULL, ...)

\S4method{dbListFields}{AthenaConnection,character}(conn, name, ...)

\S4method{dbExistsTable}{AthenaConnection,character}(conn, name, ...)

\S4method{dbExistsTable}{AthenaConnection,Id}(conn, name, ...)

\S4method{dbRemoveTable}{AthenaConnection,character}(conn, name, delete_data = TRUE, confirm = FALSE, ...)

\S4method{dbRemoveTable}{AthenaConnection,Id}(conn, name, delete_data = TRUE, confirm = FALSE, ...)

\S4method{dbGetQuery}{AthenaConnection,character}(conn, statement, statistics = FALSE, unload = athena_unload(), ...)

\S4method{dbGetInfo}{AthenaConnection}(dbObj, ...)

dbGetPartition(conn, name, ..., .format = FALSE)

\S4method{dbGetPartition}{AthenaConnection}(conn, name, ..., .format = FALSE)

dbShow(conn, name, ...)

\S4method{dbShow}{AthenaConnection}(conn, name, ...)

\S4method{dbBegin}{AthenaConnection}(conn, ...)

\S4method{dbCommit}{AthenaConnection}(conn, ...)

\S4method{dbRollback}{AthenaConnection}(conn, ...)
}
\arguments{
\item{object}{Any R object}

\item{conn}{A \link[DBI:DBIConnection-class]{DBI::DBIConnection} object,
as returned by \link[DBI:dbConnect]{dbConnect()}.}

\item{...}{Other parameters passed on to methods.}

\item{dbObj}{An object inheriting from \code{DBIObject}, i.e. \code{DBIDriver},
\code{DBIConnection}, or a \code{DBIResult}.}

\item{statement}{a character string containing SQL.}

\item{unload}{boolean input to modify \code{statement} to align with \href{https://docs.aws.amazon.com/athena/latest/ug/unload.html}{AWS Athena UNLOAD},
default is set to \code{FALSE}.}

\item{obj}{An R object whose SQL type we want to determine.}

\item{x}{A character vector to quote as string.}

\item{catalog}{Athena catalog, default set to NULL to return all tables from all Athena catalogs}

\item{schema}{Athena schema, default set to NULL to return all tables from all Athena schemas.
Note: The use of DATABASE and SCHEMA is interchangeable within Athena.}

\item{name}{The table name, passed on to \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[DBI:Id]{Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[DBI:SQL]{SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}

\item{delete_data}{Deletes S3 files linking to AWS Athena table}

\item{confirm}{Allows for S3 files to be deleted without the prompt check. It is recommend to leave this set to \code{FALSE}
to avoid deleting other S3 files when the table's definition points to the root of S3 bucket.}

\item{statistics}{If set to \code{TRUE} will print out AWS Athena statistics of query.}

\item{.format}{re-formats AWS Athena partitions format. So that each column represents a partition
from the AWS Athena table. Default set to \code{FALSE} to prevent breaking previous package behaviour.}
}
\value{
\code{dbGetTables()} returns a data.frame.

data.frame that returns all partitions in table, if no partitions in Athena table then
function will return error from Athena.

\code{dbShow()} returns \code{\link[DBI]{SQL}} characters of the Athena table DDL.
}
\description{
Implementations of pure virtual functions defined in the \code{DBI} package
for AthenaConnection objects.

Method to get Athena schema, tables and table types return as a data.frame

This method returns all partitions from Athena table.

Executes a statement to return the data description language (DDL) of the Athena table.
}
\section{Slots}{

\describe{
\item{\code{ptr}}{a list of connecting objects from the python SDK boto3.}

\item{\code{info}}{a list of metadata objects}

\item{\code{quote}}{syntax to quote sql query when creating Athena ddl}
}}

