% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_purchasing_power.R
\name{calc_purchasing_power}
\alias{calc_purchasing_power}
\title{Calculate purchasing power}
\usage{
calc_purchasing_power(x, years, real_interest_rate)
}
\arguments{
\item{x}{A numeric. The initial amount of money.}

\item{years}{A numeric. The number of years.}

\item{real_interest_rate}{A numeric. The yearly real interest rate.}
}
\value{
A numeric. The purchasing power.
}
\description{
Calculates changes in purchasing power over time,
taking into account the real interest rate.
}
\details{
The real interest rate is the interest rate after inflation.
If negative (e.g. equal to the average yearly inflation rate)
it can show diminishing purchasing power over time.
If positive, it can show increasing purchasing power over time,
and effect of compounding interest on the purchasing power.
}
\examples{
calc_purchasing_power(x = 10, years = 30, real_interest_rate = -0.02)
calc_purchasing_power(x = 10, years = 30, real_interest_rate = 0.02)

}
\seealso{
\itemize{
\item \href{https://www.r4good.academy/en/blog/optimal-asset-allocation/index.en.html#why-keeping-all-your-savings-in-cash-isnt-the-best-idea}{How to Determine Our Optimal Asset Allocation?}
}
}
