% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{terms_graph}
\alias{terms_graph}
\title{terms_graph}
\usage{
terms_graph(
  dtm,
  n = 100,
  min_occ = 0,
  interactive = base::interactive(),
  vertex.label.cex = 1,
  ...
)
}
\arguments{
\item{dtm}{A \code{DocumentTermMatrix} object.}

\item{n}{The maximum number of terms to represent.}

\item{min_occ}{The minimum number of occurrences for a term to be retained.}

\item{interactive}{If \code{TRUE}, show an interactive plot using \code{\link[igraph:tkplot]{igraph::tkplot}}. This
is the case by default for interactive sessions.}

\item{vertex.label.cex}{The font size for vertex labels.
It is interpreted as a multiplication factor of some device-dependent base font size.}

\item{...}{Optional arguments passed to \code{\link[igraph:plot.igraph]{igraph::plot.igraph}} or \code{\link[igraph:tkplot]{igraph::tkplot}}.}
}
\value{
The ID of the plot returned by \code{\link[igraph:tkplot]{igraph::tkplot}} if \code{interactive=TRUE},
or \code{NULL} invisibly otherwise.
}
\description{
Plot a graph of terms.
}
\examples{

file <- system.file("texts", "reut21578-factiva.xml", package="tm.plugin.factiva")
corpus <- import_corpus(file, "factiva", language="en")
dtm <- build_dtm(corpus)
terms_graph(dtm, 100, 3)

}
