% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonparametric_fits.R
\name{growth.gcBootSpline}
\alias{growth.gcBootSpline}
\title{Perform a bootstrap on growth vs. time data followed by spline fits for each resample}
\usage{
growth.gcBootSpline(time, data, gcID = "undefined", control = growth.control())
}
\arguments{
\item{time}{Vector of the independent variable (usually: time).}

\item{data}{Vector of dependent variable (usually: growth values).}

\item{gcID}{(Character) The name of the analyzed sample.}

\item{control}{A \code{grofit.control} object created with \code{\link{growth.control}}, defining relevant fitting options.}
}
\value{
A \code{gcBootSpline} object containing a distribution of growth parameters and
a \code{gcFitSpline} object for each bootstrap sample. Use \code{\link{plot.gcBootSpline}}
to visualize all bootstrapping splines as well as the distribution of
physiological parameters.
\item{raw.time}{Raw time values provided to the function as \code{time}.}
\item{raw.data}{Raw growth data provided to the function as \code{data}.}
\item{gcID}{(Character) Identifies the tested sample.}
\item{boot.time}{Table of time values per column, resulting from each spline fit of the bootstrap.}
\item{boot.data}{Table of growth values per column, resulting from each spline fit of the bootstrap.}
\item{boot.gcSpline}{List of \code{gcFitSpline} object, created by \code{\link{growth.gcFitSpline}} for each resample of the bootstrap.}
\item{lambda}{Vector of estimated lambda (lag time) values from each bootstrap entry.}
\item{mu}{Vector of estimated mu (maximum growth rate) values from each bootstrap entry.}
\item{A}{Vector of estimated A (maximum growth) values from each bootstrap entry.}
\item{integral}{Vector of estimated integral values from each bootstrap entry.}
\item{bootFlag}{(Logical) Indicates the success of the bootstrapping operation.}
\item{control}{Object of class \code{grofit.control} containing list of options passed to the function as \code{control}.}
}
\description{
\code{growth.gcBootSpline} resamples the growth-time value pairs in a dataset with replacement and performs a spline fit for each bootstrap sample.
}
\examples{
# Create random growth dataset
rnd.dataset <- rdm.data(d = 35, mu = 0.8, A = 5, label = 'Test1')

# Extract time and growth data for single sample
time <- rnd.dataset$time[1,]
data <- rnd.dataset$data[1,-(1:3)] # Remove identifier columns

# Introduce some noise into the measurements
data <- data + stats::runif(97, -0.01, 0.09)

# Perform bootstrapping spline fit
TestFit <- growth.gcBootSpline(time, data, gcID = 'TestFit',
              control = growth.control(fit.opt = 's', nboot.gc = 50))

plot(TestFit, combine = TRUE, lwd = 0.5)

}
\references{
Matthias Kahm, Guido Hasenbrink, Hella Lichtenberg-Frate, Jost Ludwig, Maik Kschischo (2010). \emph{grofit: Fitting Biological Growth Curves with R}. Journal of Statistical Software, 33(7), 1-21. DOI: 10.18637/jss.v033.i07
}
\seealso{
Other growth fitting functions: 
\code{\link{growth.drFit}()},
\code{\link{growth.gcFit}()},
\code{\link{growth.gcFitLinear}()},
\code{\link{growth.gcFitModel}()},
\code{\link{growth.gcFitSpline}()},
\code{\link{growth.workflow}()}
}
\concept{growth fitting functions}
