% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_powerest.R
\name{pred_powerest}
\alias{pred_powerest}
\title{Power value prediction}
\usage{
pred_powerest(x,n.grid=30,xlim=NULL,ylim=NULL)
}
\arguments{
\item{x}{A \href{https://CRAN.R-project.org/package=Seurat}{Seurat} object.}

\item{n.grid}{The grid note number within 'xlim' and 'ylim', default=30.}

\item{xlim}{The range of the absolute value of log2FC used for prediction, default=NULL which means the original range.}

\item{ylim}{The range of the avg_pct used for prediction, default=NULL which means the original range.}
}
\value{
The prediction values of the power.
}
\description{
This function provides the prediction from the \href{https://CRAN.R-project.org/package=Seurat}{Seurat}
object which could be used for visualization by 'plotly_powerest' and 'vis_powerest' or
the power result for your proposal or research. And it is a modified version of the scam library code predict.scam.
}
\examples{
data(result_example)
 \donttest{b<-fit_powerest(result_example$power,result_example$avg_logFC,result_example$avg_PCT)}
 \donttest{pred <- pred_powerest(b,xlim= c(0,6),ylim=c(0,1))}

}
\author{
Lan Shui \email{lshui@mdanderson.org} based partly on 'scam' by Natalya Pya
}
