% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addObservationPeriodId.R
\name{addObservationPeriodId}
\alias{addObservationPeriodId}
\title{Add the ordinal number of the observation period associated that a given date
is in.}
\usage{
addObservationPeriodId(
  x,
  indexDate = "cohort_start_date",
  nameObservationPeriodId = "observation_period_id",
  name = NULL
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{indexDate}{Variable in x that contains the date to compute the
observation flag.}

\item{nameObservationPeriodId}{Name of the new column.}

\item{name}{Name of the new table, if NULL a temporary table is returned.}
}
\value{
Table with the current observation period id added.
}
\description{
Add the ordinal number of the observation period associated that a given date
is in.
}
\examples{
\donttest{
library(PatientProfiles)

cdm <- mockPatientProfiles(source = "duckdb")

cdm$cohort1 |>
  addObservationPeriodId()

}

}
