% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/B02-bootstrap-variance.R
\name{var_marginalcox_bootstrap}
\alias{var_marginalcox_bootstrap}
\title{Bootstrap Variance Estimation for Marginal Cox Model}
\usage{
var_marginalcox_bootstrap(
  data,
  treatment_var,
  time_var,
  event_var,
  ps_formula,
  treatment_levels,
  reference_level,
  estimand = "ATE",
  att_group = NULL,
  trim = NULL,
  delta = NULL,
  alpha = NULL,
  boot_level = "full",
  B = 100,
  robust = TRUE,
  parallel = FALSE,
  mc.cores = 2,
  seed = NULL
)
}
\arguments{
\item{data}{A data.frame containing the complete-case analysis data.}

\item{treatment_var}{Character string specifying the treatment variable name.}

\item{time_var}{Character string specifying the time variable name.}

\item{event_var}{Character string specifying the event variable name.}

\item{ps_formula}{A formula object for the propensity score model.}

\item{treatment_levels}{Vector of treatment levels (from main fit_marginal_cox).}

\item{reference_level}{Reference treatment level (from main fit_marginal_cox).}

\item{estimand}{Character string: "ATE", "ATT", or "overlap".}

\item{att_group}{For ATT, which group to target. NULL otherwise.}

\item{trim}{Trimming method: NULL, "symmetric", or "asymmetric".}

\item{delta}{Symmetric trimming threshold (NULL uses defaults).}

\item{alpha}{Asymmetric trimming threshold (NULL uses defaults).}

\item{boot_level}{Bootstrap sampling level: "full" (default) samples from
entire dataset, "strata" samples within each treatment group preserving
group sizes.}

\item{B}{Integer number of bootstrap iterations. Default 100.}

\item{robust}{Logical. Use robust variance in Cox model? Default TRUE.}

\item{parallel}{Logical. If TRUE, use parallel computation via mclapply.
Default FALSE.}

\item{mc.cores}{Integer number of cores for parallel processing. Default 2.}

\item{seed}{Optional random seed for reproducibility. Default NULL.}
}
\value{
A list containing:
  \item{boot_samples}{List of length B with hr_estimates from each iteration.}
  \item{boot_allocation}{Matrix (B x n_levels) of group sample sizes per trial.}
  \item{n_used_boot}{Matrix (B x n_levels) of sample sizes used in Cox model
    per trial (after trimming).}
  \item{events_used_boot}{Matrix (B x n_levels) of event counts used in Cox
    model per trial (after trimming).}
  \item{n_success_by_group}{Named integer vector of successful estimates per group
    (non-NA across B trials).}
  \item{B}{Number of bootstrap iterations.}
  \item{boot_level}{Bootstrap method used.}
  \item{treatment_levels}{Treatment levels used.}
  \item{reference_level}{Reference level used.}
}
\description{
Estimates variance of marginal hazard ratios via bootstrap resampling.
Bootstrap Variance for Marginal Cox Model

Performs bootstrap resampling to estimate variance of log hazard ratios
from weighted marginal Cox model. Supports full (unstratified) and
stratified bootstrap by treatment group.
}
\details{
\strong{Bootstrap Workflow:}
For each bootstrap iteration:
\enumerate{
  \item Resample data with replacement (full or stratified by treatment)
  \item Estimate propensity scores on bootstrap sample
  \item Calculate weights (with optional trimming)
  \item Fit marginal Cox model using fit_marginal_cox with functionality="boot"
  \item Record estimates, sample sizes, and event counts
}

\strong{Parallel Processing:}
Uses parallel::mclapply for parallel bootstrap. Set ncores > 1 to enable.
Note: mclapply uses forking (not available on Windows).

\strong{Error Handling:}
Uses fit_marginal_cox(..., functionality="boot") which returns NA for failed
estimates instead of throwing errors. This ensures all B trials complete.
}
\keyword{internal}
