% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/B01-estimator-marginal-cox.R
\name{fit_marginal_cox}
\alias{fit_marginal_cox}
\title{Marginal Cox Model Estimation with Propensity Score Weighting}
\usage{
fit_marginal_cox(
  data,
  treatment_var,
  time_var,
  event_var,
  weights,
  treatment_levels,
  reference_level,
  robust = TRUE,
  functionality = "main"
)
}
\arguments{
\item{data}{A data.frame containing the complete-case analysis data.}

\item{treatment_var}{A character string specifying the name of the treatment
variable in \code{data}.}

\item{time_var}{A character string specifying the name of the time variable
in \code{data}.}

\item{event_var}{A character string specifying the name of the event variable
in \code{data}. Should be coded as 1 = event, 0 = censored.}

\item{weights}{A numeric vector of propensity score weights with length equal
to nrow(data). Returned from \code{estimate_weights()}. May contain zeros
for trimmed observations (these will be excluded before fitting).}

\item{treatment_levels}{A vector of unique treatment values (sorted). Should
match the levels from \code{estimate_ps()}.}

\item{reference_level}{Which treatment level to use as reference in the Cox
model. MANDATORY parameter.}

\item{robust}{Logical. Use robust (sandwich) variance estimator? Default TRUE.
When TRUE, uses \code{coxph(..., robust = TRUE)}.}

\item{functionality}{Character string indicating purpose: "main" for main
point estimation or "boot" for bootstrap. Default "main". Controls error
handling behavior when groups are missing or have no events.}
}
\value{
A list containing:
  \item{cox_model}{The fitted coxph model object. NULL if fitting failed in bootstrap mode.}
  \item{hr_estimates}{Named numeric vector of log hazard ratios (coefficients).
    Length = n_levels - 1. Names indicate which group is compared to reference
    (e.g., "trtB" means group B vs reference). Contains NA for groups that are
    missing in data or have no events.}
  \item{hr_se_robust}{Named numeric vector of robust standard errors for log HRs.
    Same length and names as hr_estimates. NA for failed groups.}
  \item{reference_level}{The treatment level used as reference.}
  \item{treatment_levels}{Vector of all treatment levels.}
  \item{n_levels}{Number of treatment levels.}
  \item{n_per_group_original}{Named numeric vector of sample sizes per group
    before trimming (from original data).}
  \item{n_per_group_used}{Named numeric vector of sample sizes per group
    actually used in Cox model (after excluding zero weights).}
  \item{events_per_group_original}{Named numeric vector of event counts per
    group before trimming.}
  \item{events_per_group_used}{Named numeric vector of event counts per group
    in fitted Cox model.}
}
\description{
Fits a weighted marginal Cox proportional hazards model to estimate
marginal hazard ratios between treatment groups using propensity score weights.
Fit Weighted Marginal Cox Model

Fits a marginal Cox model `Surv(time, event) ~ treatment` with propensity
score weights to estimate marginal hazard ratios. Automatically handles
zero weights (from trimming) by subsetting data before fitting.
}
\details{
\strong{Functionality Modes:}

**"main" mode (point estimation):**
- If reference group is missing or has no events after trimming: throws error
- If non-reference group is missing: sets its HR and SE to NA, continues
- If non-reference group has no events: sets its HR and SE to NA if coxph fails
- Does NOT suppress warnings/messages from coxph

**"boot" mode (bootstrap):**
- If reference group is missing or has no events: returns hr_estimates with all NA, no error
- If non-reference group is missing: sets its HR and SE to NA
- Does NOT suppress warnings (this is handled in bootstrap wrapper function)

\strong{Model Formula:}
Fits \code{Surv(time, event) ~ treatment} where treatment is a factor with
k levels. Cox regression automatically creates k-1 dummy variables relative
to the reference level.

\strong{Zero Weights:}
coxph does not accept zero or negative weights. Observations with weight <= 0
are excluded before model fitting. This handles trimming automatically.

\strong{Coefficients:}
Coefficients represent log hazard ratios. To get hazard ratios, use
\code{exp(hr_estimates)}. A positive coefficient means higher hazard
(worse survival) compared to reference group.

\strong{Robust Variance:}
When \code{robust = TRUE}, the sandwich variance estimator accounts for
weighting and provides more conservative standard errors. This is recommended
for propensity score weighted analyses.
}
\keyword{internal}
