% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnds_labeller.R
\name{pnds_labeller}
\alias{pnds_labeller}
\title{Label categorical variables from PNDS microdata}
\usage{
pnds_labeller(data_pnds, dictionary.file)
}
\arguments{
\item{data_pnds}{A tibble of PNDS microdata read with \code{read_pnds} function.}

\item{dictionary.file}{The dictionary file for selected survey available on official website: (select the dictionary and input zip file, according to the appropriated year, microdata folder and then, inside, documentation) - \samp{https://ftp.ibge.gov.br/PNDS/}.}
}
\value{
A tibble with the data provided from PNDS survey and its categorical variables as factors with related labels.
}
\description{
This function labels categorical variables from PNDS microdata.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/estatisticas/sociais/saude/9160-pesquisa-nacional-de-demografia-e-saude.html?=&t=o-que-e}> and consult the other functions of this package, described below.
}
\examples{
# Using data read from disk
input_path <- pnds_example(path="input_example.txt")
data_path <- pnds_example(path="exampledata.txt")
dictionary.path <- pnds_example(path="dictionaryexample.xls")
pnds.df <- read_pnds(microdata=data_path, input_txt=input_path, vars=c("J007","J009"))
pnds.df <- pnds.df[(pnds.df$M001 == "1" & !is.na(pnds.df$M001)),]
pnds.df <- pnds.df[,!(names(pnds.df) \%in\% c("V0029", "V00291", "V00292", "V00293"))]
pnds.df <- pnds_labeller(data_pnds=pnds.df, dictionary.file=dictionary.path)
\donttest{
# Downloading data
pnds.df2 <- get_pnds(year=2023, section="Female", vars=c("J007","J009"),
                       labels=FALSE, deflator=FALSE, design=FALSE,
                       reload=TRUE, curlopts=list(), savedir=tempdir())
dictionary.path2 <- pnds_example(path="dictionaryexample.xls")
pnds.df2 <- pnds_labeller(data_pnds=pnds.df2, dictionary.file=dictionary.path2)}
}
\seealso{
\link[PNDSIBGE]{get_pnds} for downloading, labeling, deflating and creating survey design object for PNDS microdata.\cr \link[PNDSIBGE]{read_pnds} for reading PNDS microdata.\cr \link[PNDSIBGE]{pnds_deflator} for adding deflator variables to PNDS microdata.\cr \link[PNDSIBGE]{pnds_design} for creating PNDS survey design object.\cr \link[PNDSIBGE]{pnds_example} for getting the path of the PNDS toy example files.
}
