% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tReem.R
\name{tReem}
\alias{tReem}
\title{A function to Group Amplification Curves According to their Shape}
\usage{
tReem(data, cor = TRUE, k = 2)
}
\arguments{
\item{data}{is the cycle dependent fluorescence amplitude (y-axis).}

\item{cor}{is a logical parameter. If set true, the Pearson
correlation is used as distance measure. If set FALSE the
Hausdorff distance will be used.}

\item{k}{an integer scalar or vector with the desired number of groups.}
}
\value{
gives a \code{data.frame} (S3 class, type of \code{list}) as output for the manual analyzed data
}
\description{
\code{tReem} is a function to group amplification curves
from a quantitative PCR experiment according to their shape.
Either the Pearson correlation coefficient or the Hausdorff
distance is used as measure. In most cases the grouping based
on the Pearson correlation coefficient is sufficient. The
grouping based on the Hausdorff distance can be very slow
for large data sets.
}
\examples{
# Classify amplification curve data by Hausdorff distance
library(qpcR)
tReem(testdat[, 1:5])
}
\author{
Stefan Roediger, Andrej-Nikolai Spiess
}
\keyword{autocorrelation}
