% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_BMI_percentile.R,
%   R/get_BMI_percentile_helpers.R
\name{get_BMI_percentile}
\alias{get_BMI_percentile}
\alias{percentile_df}
\title{Calculate youth BMI percentile from CDC standards}
\usage{
get_BMI_percentile(
  weight_kg,
  height_cm,
  age_yrs = NULL,
  age_mos = NULL,
  sex = c("Male", "Female"),
  BMI = NULL,
  df = NULL,
  output = c("percentile", "classification", "both", "summary")
)

percentile_df(
  df,
  weight_kg = "default",
  height_cm = "default",
  age_yrs = "default",
  age_mos = "default",
  sex = "default",
  BMI = "default",
  output = c("percentile", "classification", "both", "summary")
)
}
\arguments{
\item{weight_kg}{Weight in kilograms}

\item{height_cm}{height in centimeters}

\item{age_yrs}{age in years}

\item{age_mos}{age in months (optional)}

\item{sex}{Character scalar indicating participant's sex}

\item{BMI}{numeric. Body mass index}

\item{df}{Optional data frame on which to operate. Default is \code{NULL}.
If passed, the preceding arguments that have been documented on this page
(\code{weight_kg}, \code{height_cm}, etc) are expected to be character
scalars naming the columns of \code{df} in which the that information can
be found}

\item{output}{What should be returned: raw percentile, weight status
classification, both percentile and classification, or a full summary (BMI,
percentile, classification, and severe obesity cutoff)?}
}
\value{
One of: A numeric scalar giving the BMI percentile (for \code{output
  = "percentile"}); a factor scalar giving the weight status (for
  \code{output = "classification"}); a list with the percentile and
  classification (for \code{output = "both"}); or a list with the BMI,
  percentile, classification, and severe obesity cutoff (for \code{output =
  "summary"}).
}
\description{
Calculate youth BMI percentile from CDC standards
}
\details{
Only one of \code{age_mos} and \code{age_yrs} is required. The
  former will be used if both are provided. If \code{age_mos} is \emph{not}
  provided, it will be calculated based on \code{age_yrs}, assuming 365.2425
  days per year and 30.4375 days per month. Depending on how the initial age
  calculation was made, rounding error will occur. Thus, use of the
  \code{\link{get_age}} function is recommended, with \code{units =
  "months"}. If \code{BMI} is provided, there is no need to pass
  \code{weight_kg} or \code{height_cm}.
}
\examples{
get_BMI_percentile(39.4, 144.5, 12.35, sex = "Male")
}
\references{
This function was developed with reference to public domain resources
provided by the Centers for Disease Control and Prevention. For more
information, see:

\url{https://www.cdc.gov/bmi/adult-calculator/bmi-categories.html}

\url{https://www.cdc.gov/growthcharts/cdc_charts.htm}
}
\seealso{
\doi{10.3945/ajcn.2009.28335}
\href{https://pubmed.ncbi.nlm.nih.gov/24016455/}{Kelly et al. (2013)}
}
\keyword{internal}
