% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_normalization_utils.R
\name{olink_norm_input_assay_overlap}
\alias{olink_norm_input_assay_overlap}
\title{Check \var{datasets} and \var{reference_medians} for Olink identifiers not
shared across datasets.}
\usage{
olink_norm_input_assay_overlap(
  lst_df,
  reference_medians,
  lst_cols,
  norm_mode = norm_mode
)
}
\arguments{
\item{lst_df}{Named list of datasets to be normalized.}

\item{reference_medians}{Dataset with columns "OlinkID" and "Reference_NPX".
Used for reference median normalization.}

\item{lst_cols}{Named list of vectors with the required column names for each
dataset in \var{lst_df}.}

\item{norm_mode}{Character string indicating the type of normalization to be
performed. Expecting one of
bridge, subset, ref_median or norm_cross_product. # nolint line_length_linter}
}
\value{
A named list containing \var{lst_df} and \var{reference_medians}
with assays shared across all datasets.
}
\description{
Check \var{datasets} and \var{reference_medians} for Olink identifiers not
shared across datasets.
}
\author{
Klev Diamanti
}
