% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NostalgiR.R
\name{nos.density}
\alias{nos.density}
\title{nos.density text-based plot of a kernel density function.}
\usage{
nos.density(data, xlab = NULL, ratio = 0.25, bw = "nrd0",
  kernel = "gaussian", locations = T, width = round(options()$width *
  0.8), height = round(ratio * width), pch = c("o", "~"))
}
\arguments{
\item{data}{A numeric vector containing the values to be plotted. \code{NA} and \code{NaN} are allowed, but are removed for the plot. Infinities will cause an error.}

\item{xlab}{Label of the x-axis of the plot.}

\item{ratio}{Coefficient that controls the aspect ratio of the plot.}

\item{bw}{A numerical value or character string to specify the bandwidth used for kernel density estimation. The default setting is \code{'nrd0'}, which is the default option in \code{\link[stats]{density}}; see \code{\link[stats]{density}} for other options.}

\item{kernel}{A character string to specify the type of smoothing kernel used. The default setting is \code{'gaussian'}, which is the default option in \code{\link[stats]{density}}; see \code{\link[stats]{density}} for other options.}

\item{locations}{If \code{TRUE}, the location of the data points are plotted along the x-axis. If \code{FALSE}, then the locations of the data points are not plotted.}

\item{width}{Width of the plot in points.}

\item{height}{Height of the plot in points.}

\item{pch}{A two dimensional vector of single-character symbols. The first symbol is for data point, and the second symbol is for the density curve.}
}
\description{
Plots a text-based of a kernel density function, with the option of plotting the location of the data points along the x-axis.
}
\note{
Due to rounding to a relatively crude grid results can only be approximate. The equally spaced axis ticks, for example, may be non-equally spaced in the plot. Further, due to the crude grid also there might be several points per character. The function uses the same plotting symbol no matter how many points coincide on one character position.
}
\examples{
## Plot a kernel density function of 10 random standard normal points with
## a Gaussian kernel and with the locations of the data plotted along the x-axis.
data <- rnorm(10)
nos.density(data)

## Plot a kernel density function of 100 random stanard normal points with
## a triangular kernel and without the locations of the data plotted along the x-axis.
data <- rnorm(100)
nos.density(data,kernel='triangular',location=FALSE)
}
\author{
Hien D. Nguyen
}
\seealso{
\code{\link[stats]{density}}, \code{\link[graphics]{plot}}, \code{\link[txtplot]{txtplot}}, and \code{\link[txtplot]{txtdensity}}.
}

