% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MvtMPareto1.R
\name{MvtMardiaPareto1}
\alias{MvtMardiaPareto1}
\alias{dmvmpareto1}
\alias{pmvmpareto1}
\alias{qmvmpareto1}
\alias{rmvmpareto1}
\alias{smvmpareto1}
\title{Mardia's Multivariate Pareto Type I Distribution}
\usage{
dmvmpareto1(x, parm1 = 1, parm2 = rep(1, k), log = FALSE)

pmvmpareto1(q, parm1 = 1, parm2 = rep(1, k))

qmvmpareto1(
  p,
  parm1 = 1,
  parm2 = rep(1, k),
  interval = c(max(1/parm2) + 1e-08, 1e+08)
)

rmvmpareto1(n, parm1 = 1, parm2 = rep(1, k))

smvmpareto1(q, parm1 = 1, parm2 = rep(1, k))
}
\arguments{
\item{x}{vector or matrix of quantiles. If \eqn{x} is a matrix, each row vector constitutes a vector of quantiles for which the density \eqn{f(x)} is calculated (for \eqn{i}-th row \eqn{x_i}, \eqn{f(x_i)} is reported).}

\item{parm1}{a scalar parameter, see parameter \eqn{a} in \strong{Details}.}

\item{parm2}{a vector of parameters, see parameters \eqn{\theta_i} in \strong{Details}.}

\item{log}{logical; if TRUE, probability densities \eqn{f} are given as \eqn{log(f)}.}

\item{q}{a vector of quantiles.}

\item{p}{a scalar value corresponding to probability.}

\item{interval}{a vector containing the end-points of the interval to be searched. Default value is set as \code{c(max(1 / parm2) + 1e-8, 1e8)} according to \eqn{x_i > 1 / \theta_i, \theta_i>0, i=1,\cdots, k}.}

\item{n}{number of observations.}

\item{k}{dimension of data or number of variates.}
}
\value{
\code{dmvmpareto1} gives the numerical values of the probability density.

\code{pmvmpareto1} gives the cumulative probability.

\code{qmvmpareto1} gives the equicoordinate quantile.

\code{rmvmpareto1} generates random numbers.

\code{smvmpareto1} gives the value of survival function.
}
\description{
Calculation of density function, cumulative distribution function, equicoordinate quantile function and survival function, and random numbers generation for Mardia's multivariate Pareto Type I distribution with a scalar parameter \code{parm1} and a vector of parameters \code{parm2}.
}
\details{
Multivariate Pareto type I distribution was introduced by Mardia (1962) as a joint probability distribution of several nonnegative random variables \eqn{X_1, \cdots, X_k}. Its probability density function is given by
\deqn{f(x_1, \cdots, x_k) = \frac{[ \prod_{i=1}^{k} \theta_i] a(a+1) \cdots (a+k-1)}{(\sum_{i=1}^{k} \theta_i x_i - k + 1)^{a+k}},}
where \eqn{x_i > 1 / \theta_i, a >0, \theta_i>0, i=1,\cdots, k}.

Cumulative distribution function \eqn{F(x_1, \dots, x_k)} is obtained by the following formula related to survival function \eqn{\bar{F}(x_1, \dots, x_k)} (Joe, 1997)
\deqn{F(x_1, \dots, x_k) = 1 + \sum_{S \in \mathcal{S}} (-1)^{|S|} \bar{F}_S(x_j, j \in S),}
where the survival function is given by
\deqn{\bar{F}(x_1, \cdots, x_k) = \left( \sum_{i=1}^{k} \theta_i x_i - k + 1 \right)^{-a}.}

Equicoordinate quantile is obtained by solving the following equation for \eqn{q} through the built-in one dimension root finding function \code{\link{uniroot}}:
\deqn{\int_{0}^{q} \cdots \int_{0}^{q} f(x_1, \cdots, x_k) dx_k \cdots dx_1 = p,}
where \eqn{p} is the given cumulative probability.

Random numbers \eqn{X_1, \cdots, X_k} from Mardia's multivariate Pareto type I distribution can be generated through linear transformation of multivariate Lomax random variables \eqn{Y_1, \cdots, Y_k} by letting \eqn{X_i = Y_i + 1/\theta_i, i = 1, \cdots, k}; see Nayak (1987).
}
\examples{
# Calculations for the Mardia's multivariate Pareto Type I with parameters:
# a = 5, theta1 = 1, theta2 = 2, theta3 = 3
# Vector of quantiles: c(2, 1, 1)

dmvmpareto1(x = c(2, 1, 1), parm1 = 5, parm2 = c(1, 2, 3)) # Density

pmvmpareto1(q = c(2, 1, 1), parm1 = 5, parm2 = c(1, 2, 3)) # Cumulative Probability

# Equicoordinate quantile of cumulative probability 0.5
qmvmpareto1(p = 0.5, parm1 = 5, parm2 =  c(1, 2, 3))

# Random numbers generation with sample size 100
rmvmpareto1(n = 100, parm1 = 5, parm2 = c(1, 2, 3)) 

smvmpareto1(q = c(2, 1, 1), parm1 = 5, parm2 = c(1, 2, 3)) # Survival function

}
\references{
Joe, H. (1997). \emph{Multivariate Models and Dependence Concepts}. London: Chapman & Hall.

Mardia, K. V. (1962). Multivariate Pareto distributions. \emph{Ann. Math. Statist.} 33, 1008-1015.

Nayak, T. K. (1987). Multivariate Lomax Distribution: Properties and Usefulness in Reliability Theory. \emph{Journal of Applied Probability}, Vol. 24, No. 1, 170-177.
}
\seealso{
\code{\link{uniroot}} for one dimensional root (zero) finding.
}
