% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{psych_neurocog_df}
\alias{psych_neurocog_df}
\title{Psychotic Cognition}
\format{
A data frame with 242 observations and 10 variables:
\describe{
  \item{Dx}{Factor with 3 levels: Diagnostic group (Schizophrenia/Schizoaffective/Control)}
  \item{Speed}{Integer: Processing speed score}
  \item{Attention}{Integer: Attention/vigilance score}
  \item{Memory}{Integer: Working memory score}
  \item{Verbal}{Integer: Verbal learning score}
  \item{Visual}{Integer: Visual learning score}
  \item{ProbSolv}{Integer: Problem solving score}
  \item{SocialCog}{Integer: Social cognition score}
  \item{Age}{Integer: Participant age in years}
  \item{Sex}{Factor with 2 levels: Participant sex}
}
}
\source{
Data taken from the heplots package version 1.7.4. Original research:
Hartman, L.I. (2016) Schizophrenia and Schizoaffective Disorder: One Condition or Two?
Unpublished PhD dissertation, York University.
}
\usage{
data(psych_neurocog_df)
}
\description{
This dataset, psych_neurocog_df, is a data frame containing comprehensive
neurocognitive assessments from a study comparing performance patterns in schizophrenia,
schizoaffective disorder, and controls. The data includes 242 observations across
multiple cognitive domains using a psychosis-specific neurocognitive battery.
}
\details{
The dataset name has been updated to 'psych_neurocog_df' for brevity and clarity,
while maintaining consistency with the naming style of the NeuroDataSets package.
The suffix 'df' indicates that the dataset is a data frame.
}
