% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotV.R
\name{plotV}
\alias{plotV}
\title{Plot of layer-specific network generation rules.}
\usage{
plotV(OUT, main = "", point_size = 3, line_size = 1)
}
\arguments{
\item{OUT}{Output of networkchange objects.}

\item{main}{The title of plot}

\item{point_size}{Point size (default: 3)}

\item{line_size}{Line width (default: 1)}
}
\value{
A ggplot2 plot object
}
\description{
Plot layer-specific network generation rules using ggplot2.
Uses colorblind-friendly viridis palette for publication-quality output.
}
\examples{

   \dontrun{set.seed(1973)
   \## generate an array with two constant blocks
   Y <- MakeBlockNetworkChange(n=10, shape=10, T=40, type ="constant")
   out0 <- NetworkStatic(Y, R=2, mcmc=10, burnin=10,
   verbose=10, UL.Normal = "Orthonormal")
   \## latent node positions
   plotV(out0)
   }
}
