% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotU.R
\name{plotU}
\alias{plotU}
\title{Plot of latent node positions}
\usage{
plotU(OUT, Time = NULL, names = NULL, main = NULL, label.prob = 0.9)
}
\arguments{
\item{OUT}{Output of networkchange objects.}

\item{Time}{Starting of the time period. If NULL, 1.}

\item{names}{Node names. If NULL, use natural numbers.}

\item{main}{The title of plot}

\item{label.prob}{Label print threshold. 0.9 is the default.}
}
\value{
A plot object
}
\description{
Plot latent node positions using ggplot2 with patchwork for multi-panel layouts.
Uses colorblind-friendly palettes and cross-platform compatible fonts.
}
\examples{

   \dontrun{
   set.seed(1973)
   \## generate an array with two constant blocks
   Y <- MakeBlockNetworkChange(n=10, shape=10, T=40, type ="constant")
   out0 <- NetworkStatic(Y, R=2, mcmc=10, burnin=10,
   verbose=10, UL.Normal = "Orthonormal")
   \## latent node positions
   plotU(out0)
   }
}
