% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.nmadt.R
\name{summary.nmadt}
\alias{summary.nmadt}
\title{Summary method for `nmadt` objects}
\usage{
\method{summary}{nmadt}(object, ...)
}
\arguments{
\item{object}{An object of class \code{nmadt}, 
typically created by \code{nmadt.hierarchical()} or \code{nmadt.hsroc()}.}

\item{...}{Additional arguments (currently not used).}
}
\value{
The function returns the input \code{object} (invisibly) after printing the summary.
}
\description{
Provides a concise summary of posterior results from network meta-analysis
of diagnostic tests fitted using the \code{NMADTA} framework.  
Displays median estimates and 95% credible intervals for
sensitivity, specificity, predictive values, likelihood ratios, and prevalence.
}
\details{
The function extracts and prints key posterior summaries from the fitted model, 
including medians and 95% equal-tail credible intervals (CrI) for diagnostic accuracy parameters.

The output is formatted for human readability, with each section clearly labeled.
}
\examples{
\donttest{
data(dat.kang)
set.seed(9)
kang.out <- nmadt.hierarchical(nstu=12, K=2, data=dat.kang, 
            testname=c("D-dimer","Ultrasonography"))
summary(kang.out) 
}

}
