% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse-network.R
\name{analyseNetwork}
\alias{analyseNetwork}
\title{General properties of the network}
\usage{
analyseNetwork(graph)
}
\arguments{
\item{graph}{An \code{igraph} object.}
}
\value{
A list containing \code{vertices} and \code{edges} centrality values as well as \code{general_stats} for the whole network.
}
\description{
Generic function for network properties, allowing you to get a quick overview of the network topology.
}
\details{
The following measurements are calculated in one step using the \href{https://igraph.org/r/}{igraph} package to analyze the input graph object: the Degree, Betweenness, Closeness, Kleinberg's hub score and Eigenvector centrality of nodes (vertices), the Betweenness centrality of edges, number of nodes, edges and components, the edge density, global Eigenvector centrality value and global Kleinberg's hub centrality score.
}
\examples{
# generate a toy graph
g1 <- igraph::make_graph(c(1, 2, 3, 4, 1, 3), directed = FALSE)
igraph::V(g1)$name <- c("n1", "n2", "n3", "n4")

# generate random graph according to the Erdos-Renyi model
g2 <- igraph::sample_gnm(10, 23)
igraph::V(g2)$name <- letters[1:10]

# run analyseNetwork
analyseNetwork(g1)
analyseNetwork(g2)
}
\seealso{
\code{\link[igraph]{vcount}}, \code{\link[igraph]{ecount}},
\code{\link[igraph]{edge_density}}, \code{\link[igraph]{count_components}},
\code{\link[igraph]{degree}},\code{\link[igraph]{betweenness}},
\code{\link[igraph]{edge_betweenness}},\code{\link[igraph]{closeness}},
\code{\link[igraph]{eigen_centrality}},\code{\link[igraph]{hub_score}}.
}
