% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEIR_prob.R
\name{SEIR_prob}
\alias{SEIR_prob}
\title{Transition probabilities of an SEIR process}
\usage{
SEIR_prob(
  t,
  alpha,
  beta,
  kappa,
  S0,
  E0,
  I0,
  nSE,
  nEI,
  nIR,
  direction = c("Forward", "Backward"),
  nblocks = 20,
  tol = 1e-12,
  computeMode = 0,
  nThreads = 4
)
}
\arguments{
\item{t}{time}

\item{alpha}{removal rate}

\item{beta}{infection rate}

\item{kappa}{rate at which an exposed person becomes infective}

\item{S0}{initial susceptible population}

\item{E0}{initial exposed population}

\item{I0}{initial infectious population}

\item{nSE}{number of infection events}

\item{nEI}{number of events at which an exposed person becomes infective}

\item{nIR}{number of removal events}

\item{direction}{direction of the transition probabilities (either \code{Forward} or \code{Backward})}

\item{nblocks}{number of blocks}

\item{tol}{tolerance}

\item{computeMode}{computation mode}

\item{nThreads}{number of threads}
}
\value{
a matrix of the transition probabilities
}
\description{
Computes the transition pobabilities of an SIR process
using the bivariate birth process representation
}
