\name{ContributionPlot}
\alias{ContributionPlot}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Contribution plots for several Biplots
}
\description{
Plots contribution plots
}
\usage{
ContributionPlot(Structure, A1 = 1, A2 = 2, Colors = NULL, Labs = NULL, MinQuality = 0, 
                 CorrelationScale = FALSE, ContributionScale = TRUE, AddSigns2Labs = TRUE, 
                 Title = "Contribution Plot", ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{Structure}{
A matrix with the loadings (structure) or correlations among observed and latent variables.
}
  \item{A1}{
Factor for the first axis of the plot
}
  \item{A2}{
Factor for the second axis of the plot
}
  \item{Colors}{
Colors for the variables
}
  \item{Labs}{
Lables for the variables 
}
  \item{MinQuality}{
Minimum quality of representation for a variable  to be plotted.
}
  \item{CorrelationScale}{
The scale os  the graph is for correlations
}
  \item{ContributionScale}{
The scale os  the graph is for contributions
}
  \item{AddSigns2Labs}{
Should the plot have the signs of the correlations
}
  \item{Title}{
Title of the plot
}
  \item{\dots}{
Aditional parameters
}
}
\details{
Performs a contribution plot.
}
\value{
The contribution plot.
}

\author{
Jose Luis Vicente-Villardon
}

\examples{
data(Protein)
bip=PCA.Biplot(Protein[,3:11])
ContributionPlot(bip$Structure)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory (show via RShowDoc("KEYWORDS")):
% \keyword{ ~kwd1 }
% \keyword{ ~kwd2 }
% Use only one keyword per line.
% For non-standard keywords, use \concept instead of \keyword:
% \concept{ ~cpt1 }
% \concept{ ~cpt2 }
% Use only one concept per line.
