summary.Ordinal.Logistic.Biplot <- function(object, latex=FALSE , Show=NULL, ...){

  cat(object$Title)
  cat("\nType of Biplot : ", object$Type)
  cat("\nType of fit : ",object$Fit)
  cat("\nInitial (External) Configuration : ",object$InitialConfiguration)
  cat("\nPenalization for the logistic regression : ",object$Penalization)
  cat("\n\n\nCOLUMN PARAMETERS")
  cat("\nThresholds\n")
  print(object$ColumnParameters$thresholds)
  cat("\n\nSlopes (Discriminations) \n")
  print(object$ColumnParameters$coefficients)
  n=dim(object$RowCoordinates)[1]
  p=dim(object$Communalities)[1]
  if (is.null(Show)) Show=rep(TRUE,p)
  
  cat("\n\nMeasures of fit (Global and for each separate variable) \n")
  Fit=object$ColumnParameters$fit[Show,]
  print(Fit)

  cat("\n\nFactor Structure (Loadings and Communalities) \n")
  Loads=cbind(object$loadings, object$Communalities)
  print(Loads[Show,])
  cat("\n\nFactor Structure (Explained Variance) \n")
  Explained=apply(object$loadings^2, 2, sum)
  nvar=dim(object$Data)[2]
  VarExp=rbind(Explained, cumsum(Explained), 100*Explained/nvar, 100*cumsum(Explained)/nvar)
  rownames(VarExp)=c("Variance", "Cummulative", "Percentage", "Cum. Percentage")
  colnames(VarExp)=paste("Dim", 1:ncol(VarExp))
  print(VarExp)
  cat("\nAIC : ", object$ColumnParameters$AIC)
  cat("\nBIC : ", object$ColumnParameters$BIC)
  
  if (latex){
    print(xtable(Fit[,c(6,7,8,10,11)], caption="Measures of fit (Global and for each separate variable)"))
    print(xtable(Loads[Show,], caption="Factor Structure (Loadings and Communalities)"))
    print(xtable(VarExp, caption="Factor Structure (Explained Variance)"))
  }
}
