% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_div_test.R, R/dada_phyloseq.R
\name{taxa_only_in_one_level}
\alias{taxa_only_in_one_level}
\title{Show taxa which are present in only one given level of a modality}
\usage{
taxa_only_in_one_level(
  physeq,
  modality,
  level,
  min_nb_seq_taxa = 0,
  min_nb_samples_taxa = 0
)

taxa_only_in_one_level(
  physeq,
  modality,
  level,
  min_nb_seq_taxa = 0,
  min_nb_samples_taxa = 0
)
}
\arguments{
\item{physeq}{(required) a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{modality}{(required) The name of a column present in the \verb{@sam_data} slot
of the physeq object. Must be a character vector or a factor.}

\item{level}{(required) The level (must be present in modality) of interest}

\item{min_nb_seq_taxa}{(default 0 = no filter) The minimum number of sequences per taxa}

\item{min_nb_samples_taxa}{(default 0 = no filter) The minimum number of samples per taxa}
}
\value{
A vector of taxa names

A vector of taxa names
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}

\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Given one modality name in sam_data and one level of the modality,
return the taxa strictly specific of this level.
}
\examples{
data_fungi_mini_woNA4height <- subset_samples(
  data_fungi_mini,
  !is.na(data_fungi_mini@sam_data$Height)
)
taxa_only_in_one_level(data_fungi_mini_woNA4height, "Height", "High")
#' # Taxa present only in low height samples
suppressMessages(suppressWarnings(
  taxa_only_in_one_level(data_fungi, "Height", "Low")
))
# Number of taxa present only in sample of time equal to 15
suppressMessages(suppressWarnings(
  length(taxa_only_in_one_level(data_fungi, "Time", "15"))
))
data_fungi_mini_woNA4height <- subset_samples(
  data_fungi_mini,
  !is.na(data_fungi_mini@sam_data$Height)
)
taxa_only_in_one_level(data_fungi_mini_woNA4height, "Height", "High")
#' # Taxa present only in low height samples
suppressMessages(suppressWarnings(
  taxa_only_in_one_level(data_fungi, "Height", "Low")
))
# Number of taxa present only in sample of time equal to 15
suppressMessages(suppressWarnings(
  length(taxa_only_in_one_level(data_fungi, "Time", "15"))
))
}
\author{
Adrien Taudière
}
