% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_functions.R
\name{tax_datatable}
\alias{tax_datatable}
\title{Make a datatable with the taxonomy of a \code{\link[phyloseq]{phyloseq-class}} object}
\usage{
tax_datatable(
  physeq,
  abundance = TRUE,
  taxonomic_level = NULL,
  modality = NULL,
  ...
)
}
\arguments{
\item{physeq}{(required) a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{abundance}{(logical, default TRUE) Does the number of sequences is print}

\item{taxonomic_level}{(default: NULL) a vector of selected taxonomic
level using their column numbers (e.g. taxonomic_level = 1:7)}

\item{modality}{(default: NULL) A sample modality to split
OTU abundancy by level of the modality}

\item{...}{Other argument for the datatable function}
}
\value{
A datatable
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-maturing-blue" alt="lifecycle-maturing"></a>
}}


An interactive table for phyloseq taxonomy.
}
\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "windows") withAutoprint(\{ # examplesIf}
data("GlobalPatterns", package = "phyloseq")
if (requireNamespace("DT")) {
  tax_datatable(subset_taxa(
    GlobalPatterns,
    rowSums(GlobalPatterns@otu_table) > 10000
  ))

  # Using modality
  tax_datatable(GlobalPatterns,
    modality = GlobalPatterns@sam_data$SampleType
  )
}
\dontshow{\}) # examplesIf}
}
\author{
Adrien Taudière
}
