% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diceCoefficient.R
\name{diceCoefficient}
\alias{diceCoefficient}
\title{diceCoefficient}
\usage{
diceCoefficient(datInput)
}
\arguments{
\item{datInput}{Data frame with column names: Experiment.id, Replicate, Bait,
Prey, and count (i.e., prey count).}
}
\value{
Data frame containing bait-prey pairs with Dice coefficient score,
a number between 0 and 1
}
\description{
This function applies Dice coefficient to score instances
(e.g., bait-prey interactions (BPIs) in the data.frame.The Dice coefficient was first applied by Zhang et al., 2008
to score interactions between all identified proteins (baits and preys) in a given AP-MS experiment.
}
\examples{
data(SampleDatInput)
datScoring <- diceCoefficient(SampleDatInput)
head(datScoring)
}
\references{
Zhang, B., Park, B.-H., Karpinets, T., and Samatova, N. F. (2008).
From pull-down data to protein interaction networks and complexes with biological relevance.
Bioinformatics 24, 979-986.
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
