% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcee_helper_estimation.R
\name{.mcee_fit_nuisance}
\alias{.mcee_fit_nuisance}
\title{Fit a single nuisance component with flexible learner support}
\usage{
.mcee_fit_nuisance(
  config,
  data_for_fitting,
  data_for_predicting,
  lhs_var,
  param_name,
  data_for_fitting_name
)
}
\arguments{
\item{config}{Configuration list describing how to fit the nuisance parameter.
Created by \code{\link{mcee_config_maker}} or helper functions. Contains:
\itemize{
  \item **Known values**: \code{known}, \code{known_a1}, \code{known_a0} (bypasses fitting)
  \item **Model-based**: \code{method}, \code{formula}, \code{family}, optional \code{clipping}
  \item **Method-specific**: \code{SL.library} for SuperLearner, learner-specific args
}}

\item{data_for_fitting}{Data frame subset used to train the model (e.g., available rows only).}

\item{data_for_predicting}{Data frame on which to generate predictions (usually full data).}

\item{lhs_var}{Character. Column name of the response/outcome variable to model.}

\item{param_name}{Character. Descriptive name for error messages (e.g., "p_t(1|H_t)").}

\item{data_for_fitting_name}{Character. Description of fitting data for model call display.}
}
\value{
List with components:
\describe{
  \item{\code{pred}}{Numeric vector of length \code{nrow(data_for_predicting)}
    containing predictions/fitted values.}
  \item{\code{model}}{Fitted model object (e.g., \code{glm}, \code{gam}, \code{randomForest})
    or a list descriptor for known values.}
}
}
\description{
Internal workhorse function that fits individual nuisance parameters using various
machine learning methods or known constants. Handles the complexity of different
learner APIs and provides consistent predictions.
}
\details{
**Supported Methods:**
\itemize{
  \item \code{"glm"}: Uses \code{stats::glm()} with automatic family detection
  \item \code{"lm"}: Uses \code{stats::lm()} (continuous outcomes only)
  \item \code{"gam"}: Uses \code{mgcv::gam()} supporting smooth terms
  \item \code{"rf"}: Uses \code{randomForest::randomForest()}
  \item \code{"ranger"}: Uses \code{ranger::ranger()} (faster random forest)
  \item \code{"sl"}: Uses \code{SuperLearner::SuperLearner()}
}

**Automatic Family Detection:**
When \code{family=NULL} in GLM/GAM configs:
- Binary outcomes (0/1 only): \code{binomial()}
- Continuous outcomes: \code{gaussian()}

**Known Values:**
If any of \code{known}, \code{known_a1}, \code{known_a0} is provided, no model
is fitted. Returns constant predictions and a descriptor object.
}
