% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{hwe_frequencies}
\alias{hwe_frequencies}
\title{Fast estimation of allele and genotype frequencies under Hardy-Weinberg equilibrium}
\usage{
hwe_frequencies(allele1, allele2, min_alleles = 0L)
}
\arguments{
\item{allele1}{An integer vector (starting with values 1 upwards) of first alleles}

\item{allele2}{An integer vector (starting with values 1 upwards) of second alleles}

\item{min_alleles}{A minimum number of unique alleles available}
}
\value{
A list with three variables: allele_freq for estimated allele frequencies, genotype_freq for estimated genotype_frequencies (under HWE assumption), obs_genotype is the frequency of the genotypes, available_genotypes is the number of available genotypes used for the estimation, and unique_alleles is the number of unique alleles (matches the length of allele_freq)
}
\description{
Alleles are assumed to be numerated from 1 and up with no missing label. Thus if the largest value in either allele1 or allele2 is K then we assume that there can be at least K possible alleles.
Genotypes are sorted such the the smallest allele comes first, i.e., 2x1 -> 1x2, and 2x3 -> 2x3
}
\examples{
al1 <- sample(1:5, size=1000, replace=TRUE, prob=c(.4, .2, .2, .1, .1))
al2 <- sample(1:5, size=1000, replace=TRUE, prob=c(.4, .2, .2, .1, .1))
hwe_frequencies(al1, al2)

}
\author{
Claus Ekstrom <claus@rprimer.dk>
}
