% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/founder.env.R
\name{founder.shared}
\alias{founder.shared}
\alias{founder.shared.pedigreeList}
\alias{founder.shared.pedigree}
\title{Compute a common shared environment matrix}
\usage{
founder.shared(id, ...)

\method{founder.shared}{pedigreeList}(id, ...)

\method{founder.shared}{pedigree}(id, ...)
}
\arguments{
\item{id}{either a pedigree object or pedigreeList object}

\item{\dots}{Any number of optional arguments. Not used at the moment}
}
\value{
a matrix of shared environment coefficients
}
\description{
Compute the common shared environment matrix for a set of related subjects.
The function is generic, and can accept a pedigree, or pedigreeList as the
first argument.
}
\details{
When called with a pedigreeList, i.e., with multiple families, the routine
will create a block-diagonal-symmetric `bdsmatrix' object.  Since the [i,j]
value of the result is 0 for any two unrelated individuals i and j and a
`bdsmatix' utilizes sparse representation, the resulting object is often
orders of magnitude smaller than an ordinary matrix.  When called with a
single pedigree and ordinary matrix is returned.
}
\examples{

library(kinship2)
test1 <- data.frame(id  =c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14),
                    mom =c(0, 0, 0, 0, 2, 2, 4, 4, 6,  2,  0,  0, 12, 13),
                    dad =c(0, 0, 0, 0, 1, 1, 3, 3, 3,  7,  0,  0, 11, 10),
                    sex =c(1, 2, 1, 2, 1, 2, 1, 2, 1,  1,  1,  2,  2,  2))
tped <- with(test1, pedigree(id, dad, mom, sex))
founder.shared(tped)

}
\seealso{
\code{pedigree}, \code{kinship},
}
\author{
Claus Ekstrom \email{claus@rprimer.dk}
}
\keyword{datagen}
