% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_GrowthCurve.R
\name{plot_GrowthCurve}
\alias{plot_GrowthCurve}
\title{Fit and plot a dose-response curve for luminescence data (Lx/Tx against dose)}
\usage{
plot_GrowthCurve(
  sample,
  mode = "interpolation",
  fit.method = "EXP",
  output.plot = TRUE,
  output.plotExtended = TRUE,
  plot_singlePanels = FALSE,
  verbose = TRUE,
  n.MC = 100,
  ...
)
}
\arguments{
\item{sample}{\link{data.frame} (\strong{required}):
data frame with columns for \code{Dose}, \code{LxTx}, \code{LxTx.Error} and \code{TnTx}.
The column for the test dose response is optional, but requires \code{'TnTx'} as
column name if used. For exponential fits at least three dose points
(including the natural) should be provided. If \code{fit.method = "OTORX"} you have
to provide the test dose in the same unit as the dose in a column called \code{Test_Dose}.
The function searches explicitly for this column name.}

\item{mode}{\link{character} (\emph{with default}):
selects calculation mode of the function.
\itemize{
\item \code{"interpolation"} (default) calculates the De by interpolation,
\item \code{"extrapolation"} calculates the equivalent dose by extrapolation (useful for MAAD measurements) and
\item \code{"alternate"} calculates no equivalent dose and just fits the data points.
}

Please note that for option \code{"interpolation"} the first point is considered
as natural dose}

\item{fit.method}{\link{character} (\emph{with default}):
function used for fitting. Possible options are:
\itemize{
\item \code{LIN},
\item \code{QDR},
\item \code{EXP},
\item \verb{EXP OR LIN},
\item \code{EXP+LIN},
\item \code{EXP+EXP},
\item \code{GOK},
\item \code{OTOR},
\item \code{OTORX}
}

See details in \link{fit_DoseResponseCurve}.}

\item{output.plot}{\link{logical} (\emph{with default}):
enable/disable the plot output.}

\item{output.plotExtended}{\link{logical} (\emph{with default}):
If' \code{TRUE}, 3 plots on one plot area are provided:
\enumerate{
\item growth curve,
\item histogram from Monte Carlo error simulation and
\item a test dose response plot.
}

If \code{FALSE}, just the growth curve will be plotted.}

\item{plot_singlePanels}{\link{logical} (\emph{with default}):
single plot output (\code{TRUE/FALSE}) to allow for plotting the results in
single plot windows. Requires \code{plotExtended = TRUE}.}

\item{verbose}{\link{logical} (\emph{with default}):
enable/disable output to the terminal.}

\item{n.MC}{\link{integer} (\emph{with default}):
number of MC runs for error calculation.}

\item{...}{Further arguments to \link{fit_DoseResponseCurve} (\code{fit_weights},
\code{fit_bounds}, \code{fit.force_through_origin}, \code{fit.includingRepeatedRegPoints},
\code{fit.NumberRegPoints}, \code{fit.NumberRegPointsReal}, \code{n.MC},
\code{txtProgressBar}) and graphical parameters to be passed (supported:
\code{xlim}, \code{ylim}, \code{main}, \code{xlab}, \code{ylab}).}
}
\value{
Along with a plot (if wanted) the \code{RLum.Results} object produced by
\link{fit_DoseResponseCurve} is returned.
}
\description{
A dose-response curve is produced for luminescence measurements using a
regenerative or additive protocol as implemented in \link{fit_DoseResponseCurve}
and \link{plot_DoseResponseCurve}
}
\section{Function version}{
 1.2.2
}

\examples{

##(1) plot growth curve for a dummy dataset
data(ExampleData.LxTxData, envir = environment())
plot_GrowthCurve(LxTxData)

##(1b) horizontal plot arrangement
layout(mat = matrix(c(1,1,2,3), ncol = 2))
plot_GrowthCurve(LxTxData, plot_singlePanels = TRUE)

##(2) plot the growth curve with pdf output - uncomment to use
##pdf(file = "~/Desktop/Growth_Curve_Dummy.pdf", paper = "special")
plot_GrowthCurve(LxTxData)
##dev.off()

##(3) plot the growth curve with pdf output - uncomment to use, single output
##pdf(file = "~/Desktop/Growth_Curve_Dummy.pdf", paper = "special")
temp <- plot_GrowthCurve(LxTxData, plot_singlePanels = TRUE)
##dev.off()

##(4) plot resulting function for given interval x
x <- seq(1,10000, by = 100)
plot(
 x = x,
 y = eval(temp$Formula),
 type = "l"
)

##(5) plot using the 'extrapolation' mode
LxTxData[1,2:3] <- c(0.5, 0.001)
print(plot_GrowthCurve(LxTxData, mode = "extrapolation"))

##(6) plot using the 'alternate' mode
LxTxData[1,2:3] <- c(0.5, 0.001)
print(plot_GrowthCurve(LxTxData, mode = "alternate"))

} 

\section{How to cite}{
Kreutzer, S., Dietze, M., Colombo, M., 2025. plot_GrowthCurve(): Fit and plot a dose-response curve for luminescence data (Lx/Tx against dose). Function version 1.2.2. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.1. https://r-lum.github.io/Luminescence/
}

\references{
Berger, G.W., Huntley, D.J., 1989. Test data for exponential fits. Ancient TL 7, 43-46.

Guralnik, B., Li, B., Jain, M., Chen, R., Paris, R.B., Murray, A.S., Li, S.-H., Pagonis, P.,
Herman, F., 2015. Radiation-induced growth and isothermal decay of infrared-stimulated luminescence
from feldspar. Radiation Measurements 81, 224-231.

Pagonis, V., Kitis, G., Chen, R., 2020. A new analytical equation for the dose response of dosimetric materials,
based on the Lambert W function. Journal of Luminescence 225, 117333. \doi{10.1016/j.jlumin.2020.117333}
}
\seealso{
\link{fit_DoseResponseCurve}, \link{plot_DoseResponseCurve}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)\cr
Michael Dietze, GFZ Potsdam (Germany) \cr
Marco Colombo, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
