% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LWFBrook90r-package.R
\docType{package}
\name{LWFBrook90R-package}
\alias{LWFBrook90R}
\alias{LWFBrook90R-package}
\title{LWFBrook90R: A package for simulating water fluxes, soil moisture and drought
stress using the SVAT Model LWF-Brook90.}
\description{
The central function \code{run_LWFB90()} creates model input from model
control options, parameters, climate and soil data, executes the model code
and returns the model results. The model control options thereby let the user
select different methods for defining phenology and leaf area index
seasonality, root density depth distributions, and inter-annual variation of
stand properties. Additionally, a set of pedotransfer functions is provided
to derive hydraulic parameters from soil physical properties. For an
introduction to the basic usage see \code{vignette('intro_LWFB90')}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://pschmidtwalter.github.io/LWFBrook90R/}
  \item \url{https://github.com/pschmidtwalter/LWFBrook90R}
  \item Report bugs at \url{https://github.com/pschmidtwalter/LWFBrook90R/issues}
}

}
\author{
\strong{Maintainer}: Paul Schmidt-Walter \email{paulsw@posteo.de} (\href{https://orcid.org/0000-0003-2699-0893}{ORCID})

Authors:
\itemize{
  \item Volodymyr Trotsiuk (\href{https://orcid.org/0000-0002-8363-656X}{ORCID})
  \item Klaus Hammel
  \item Martin Kennel
  \item Anthony Federer
  \item Tobias Hohenbrink (\href{https://orcid.org/0000-0002-5227-0171}{ORCID})
  \item Gisbert Hetkamp
  \item Michael Köhler (\href{https://orcid.org/0000-0002-7593-5471}{ORCID})
}

Other contributors:
\itemize{
  \item Robert Nuske (\href{https://orcid.org/0000-0001-9773-2061}{ORCID}) [contributor]
  \item Bavarian State Institute of Forestry (LWF) [copyright holder, funder]
  \item Northwest German Forest Research Institute (NW-FVA) [copyright holder, funder]
}

}
\keyword{internal}
