% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IPC.R
\name{IPC}
\alias{IPC}
\title{Apply the IPC method to the Laplace factor model}
\usage{
IPC(data, m, eta)
}
\arguments{
\item{data}{The data used in the IPC analysis.}

\item{m}{is the number of principal component}

\item{eta}{is the proportion of online data to total data}
}
\value{
Ai,Di
}
\description{
This function performs Incremental Principal Component Analysis (IPC) on the provided data. It updates the estimated factor loadings and uniquenesses as new data points are processed, calculating mean squared errors and loss metrics for comparison with true values.
}
\examples{
library(LaplacesDemon)
library(MASS)
n=1000
p=10
m=5
mu=t(matrix(rep(runif(p,0,1000),n),p,n))
mu0=as.matrix(runif(m,0))
sigma0=diag(runif(m,1))
F=matrix(mvrnorm(n,mu0,sigma0),nrow=n)
A=matrix(runif(p*m,-1,1),nrow=p)
lanor <- rlaplace(n*p,0,1)
epsilon=matrix(lanor,nrow=n)
D=diag(t(epsilon)\%*\%epsilon)
data=mu+F\%*\%t(A)+epsilon
results <- IPC(data, m, eta=0.1)
print(results)
}
