% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IsoriX-datasets.R
\docType{data}
\name{CalibDataBat2}
\alias{CalibDataBat2}
\alias{CalibDataBat2Rev}
\title{Calibration datasets for bat species}
\format{
Two \emph{dataframes} with 178 observations and 6 variables:\tabular{lll}{
    \tab  \tab  \cr
   site_ID \tab (\emph{factor}) \tab Identification of the sampling site \cr
   long \tab (\emph{numeric}) \tab Longitude coordinate (decimal degrees) \cr
   lat \tab (\emph{numeric}) \tab Latitude coordinate (decimal degrees) \cr
   elev \tab (\emph{numeric}) \tab Elevation asl (m) \cr
   sample_ID \tab (\emph{factor}) \tab Identification of the sampled animal \cr
   sample_value \tab (\emph{numeric}) \tab Hydrogen delta value of the tissue \cr
}
}
\source{
data provided by Popa-Lisseanu AG et al.
}
\description{
These datasets contain hydrogen delta values of fur keratin from sedentary
bat species captured between 2005 and 2009 from Popa-Lisseanu et al. (2012).
These data can be used as an example to fit a calibration model using the
function \code{\link{calibfit}}. The difference between \code{CalibDataBat2} and
\code{CalibDataBat2Rev} is that in the latter the bat
fur isotope values were corrected to align with the current delta values for deuterium
for keratin reference materials (Soto et al. 2017, https://doi.org/10.1002/rcm.7893)
ensuring comparability between formerly and more recently normalized datasets of delta values for deuterium.
}
\details{
Users who wish to use their own dataset for calibration should create a
\emph{dataframe} of similar structure than these ones (only the column
'species' can be dropped). The columns should possess the same names as the
ones described above. If the elevation is unknown at the sampling sites,
elevation information can be extracted from a high resolution elevation
raster using the function \code{\link[terra:extract]{terra::extract}} (see \strong{Examples}).
Note that the original study used a different source of elevation data.
}
\examples{

head(CalibDataBat2)
str(CalibDataBat2)

## The following example require to have downloaded
## an elevation raster with the function getelev()
## and will therefore not run unless you uncomment it

# if (require(terra)){
#    ## We delete the elevation data
#    CalibDataBat2$elev <- NULL
#
#    ## We reconstruct the elevation data using an elevation raster
#    getelev(file = "elevBats.tif", z = 6,
#            lat_min = min(CalibDataBat2$lat),
#            lat_max = max(CalibDataBat2$lat),
#            long_min = min(CalibDataBat2$long),
#            long_max = max(CalibDataBat2$long))
#    ElevationRasterBig <- rast("elevBats.tif")
#    CalibDataBat2$elev <- extract(
#        ElevationRasterBig,
#        cbind(CalibDataBat2$long, CalibDataBat2$lat))
#    head(CalibDataBat2)
# }

}
\references{
Popa-Lisseanu AG, Soergel K, Luckner A, Wassenaar LI, Ibanez C,
Kramer-Schadt S, Ciechanowski M, Goerfoel T, Niermann I, Beuneux G,
Myslajek RW, Juste J, Fonderflick J, Kelm D & Voigt CC (2012).
A triple isotope approach to predict the breeding origins of European bats.
PLoS ONE 7(1):e30388.

Soto DX, Koehler G, Wassenaar LI & Hobson KA (2017). Re-evaluation of the hydrogen stable
isotopic composition of keratin calibration standards for wildlife and forensic
science applications. Rapid Commun Mass Spectrom. 31(14):1193-1203.
doi: 10.1002/rcm.7893. PMID: 28475227.
}
\seealso{
\code{\link{CalibDataBat}} for another (related) calibration dataset

\code{\link{calibfit}} to fit a calibration model
}
\keyword{datasets}
