% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correctByConicalPlane.R
\name{correctByConicalPlane}
\alias{correctByConicalPlane}
\title{Correct invasion data by conical plane}
\usage{
correctByConicalPlane(filename, nrfits = 1000, threshold = -30,
  plot = FALSE, write_csv = TRUE)
}
\arguments{
\item{filename}{Name of data file in csv format. It should contain columns "Pos_X", "Pos_Y" and "Pos_Z".}

\item{nrfits}{Numeric, Number of randomly chosen starting points for the optimization. Choose lower values for speeding up computational time.
Choose higher values for more reliable optimization results.}

\item{threshold}{Numeric, A threshold for counting cells as being invaded or not. When cells move towards negative z-direction, threshold should be negative.}

\item{plot}{Boole, if TRUE exemplary 3D plots before and after the correction are plotted}

\item{write_csv, }{if TRUE resulting corrected values are saved as a csv file}
}
\value{
Data.frame containing input positions, corrected z-positions as well as number and percentage of invaded cells.
}
\description{
Correct z-component of a 3D collagen invasion essay.
The correction is achieved under the assumption that non-migrating cells of the essay approximately
form a quadratic flow profile due to frictional effects, compare law of Hagen-Poiseuille for flow in a tube.
}
\author{
Marcus Rosenblatt, \email{marcus.rosenblatt@fdm.uni-freiburg.de}
}

