% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_IVDML.R
\name{bandwidth_normal}
\alias{bandwidth_normal}
\title{Compute Bandwidth Using the Normal Reference Rule}
\usage{
bandwidth_normal(A)
}
\arguments{
\item{A}{Numeric vector. The data for which the bandwidth is to be computed.}
}
\value{
A numeric value representing the computed bandwidth.
}
\description{
This function calculates the bandwidth for kernel smoothing using the Normal Reference Rule. The rule is based on Silverman's rule of thumb, which selects the bandwidth as a function of the standard deviation and interquartile range (IQR) of the data. The bandwidth is computed as: \eqn{h = 1.06 \times \min(\mathrm{sd}(A), \mathrm{IQR}(A) / 1.34) / N^{0.2}}, where \eqn{\mathrm{sd}(A)} is the standard deviation of \code{A}, \eqn{\mathrm{IQR}(A)} is the interquartile range and \code{N} is the length of \code{A}.
}
\examples{
set.seed(1)
A <- rnorm(100)
bandwidth_normal(A)

}
\references{
Silverman, B. W. (1986). \emph{Density Estimation for Statistics and Data Analysis}.  Chapman & Hall/CRC monographs on statistics and applied probability.  Chapman & Hall.
}
